/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.soapheader;

import de.osci.helper.Base64OutputStream;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Author;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Reader;
import de.osci.osci12.roles.Role;
import de.osci.osci12.soapheader.HeaderEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;

public abstract class CertificateH
extends HeaderEntry {
    protected Hashtable<String, X509Certificate> certificates = new Hashtable();
    protected byte[] tmpBuffer;

    protected void addCipherCertificate(Role role, OutputStream out) throws OSCIRoleException, IOException {
        if (role == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " null");
        }
        String name = "";
        role.getCipherCertificate();
        if (role instanceof Intermed) {
            name = "Intermediary";
        } else if (role instanceof Originator) {
            name = "Originator";
        } else if (role instanceof Addressee) {
            name = "Addressee";
        } else if (role instanceof Reader) {
            name = "OtherReader";
        } else if (role instanceof Author) {
            name = "OtherAuthor";
        } else {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + role);
        }
        out.write(("<" + this.osciNSPrefix + ":CipherCertificate" + name + " Id=\"" + role.getCipherCertificateId() + "\"><" + this.dsNSPrefix + ":X509Data><" + this.dsNSPrefix + ":X509Certificate>").getBytes(Constants.CHARSET_ENCODING));
        try {
            Base64OutputStream base64Out = new Base64OutputStream(out, true);
            base64Out.write(role.getCipherCertificate().getEncoded());
            base64Out.flush();
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(DialogHandler.text.getString("cert_gen_error") + " - " + ex.getClass() + ": " + ex.getMessage());
        }
        out.write(("</" + this.dsNSPrefix + ":X509Certificate></" + this.dsNSPrefix + ":X509Data></" + this.osciNSPrefix + ":CipherCertificate" + name + ">").getBytes(Constants.CHARSET_ENCODING));
    }

    public Hashtable<String, X509Certificate> getCertificates() {
        return this.certificates;
    }

    protected void addSignatureCertificate(Role role, OutputStream out) throws OSCIRoleException, IOException {
        String name = "";
        role.getSignatureCertificate();
        if (role instanceof Intermed) {
            name = "Intermediary";
        } else if (role instanceof Originator) {
            name = "Originator";
        } else if (role instanceof Addressee) {
            name = "Addressee";
        } else if (role instanceof Reader) {
            name = "OtherReader";
        } else if (role instanceof Author) {
            name = "OtherAuthor";
        } else {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + role);
        }
        out.write(("<" + this.osciNSPrefix + ":SignatureCertificate" + name + " Id=\"" + role.getSignatureCertificateId() + "\"><" + this.dsNSPrefix + ":X509Data><" + this.dsNSPrefix + ":X509Certificate>").getBytes(Constants.CHARSET_ENCODING));
        try {
            Base64OutputStream base64Out = new Base64OutputStream(out, true);
            base64Out.write(role.getSignatureCertificate().getEncoded());
            base64Out.flush();
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(DialogHandler.text.getString("cert_gen_error") + " - " + ex.getClass() + ": " + ex.getMessage());
        }
        out.write(("</" + this.dsNSPrefix + ":X509Certificate></" + this.dsNSPrefix + ":X509Data></" + this.osciNSPrefix + ":SignatureCertificate" + name + ">").getBytes(Constants.CHARSET_ENCODING));
    }
}

