/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.soapheader;

import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.soapheader.HeaderEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FeatureDescriptionH
extends HeaderEntry {
    private List<Constants.OSCIFeatures> supportedFeatures = new ArrayList<Constants.OSCIFeatures>();
    private long maxMessageSize = -1L;
    private long maxChunkSize = -1L;
    private long minChunkSize = -1L;
    private long chunkMessageTimeout = -1L;

    public List<Constants.OSCIFeatures> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public void setSupportedFeatures(List<Constants.OSCIFeatures> supportedFeatures) {
        this.supportedFeatures = supportedFeatures;
    }

    public long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(long maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public long getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public void setMaxChunkSize(long maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public long getMinChunkSize() {
        return this.minChunkSize;
    }

    public void setMinChunkSize(long minChunkSize) {
        this.minChunkSize = minChunkSize;
    }

    public long getChunkMessageTimeout() {
        return this.chunkMessageTimeout;
    }

    public void setChunkMessageTimeout(long chunkMessageTimeout) {
        this.chunkMessageTimeout = chunkMessageTimeout;
    }

    @Override
    protected void writeXML(OutputStream out) throws IOException, OSCIException {
        String namespacePre = this.osci2017NSPrefix;
        out.write(("<" + namespacePre + ":" + Constants.HeaderTags.FeatureDescription.getElementName()).getBytes(Constants.CHARSET_ENCODING));
        out.write(this.ns2017);
        if (this.chunkMessageTimeout != -1L) {
            out.write((" ChunkMessageTimeout=\"" + this.chunkMessageTimeout + "\"").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write((" Id=\"" + this.id + "\"").getBytes(Constants.CHARSET_ENCODING));
        if (this.maxChunkSize != -1L) {
            out.write((" MaxChunkSize=\"" + this.maxChunkSize + "\"").getBytes(Constants.CHARSET_ENCODING));
        }
        if (this.maxMessageSize != -1L) {
            out.write((" MaxMessageSize=\"" + this.maxMessageSize + "\"").getBytes(Constants.CHARSET_ENCODING));
        }
        if (this.minChunkSize != -1L) {
            out.write((" MinChunkSize=\"" + this.minChunkSize + "\"").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(">".getBytes());
        if (this.supportedFeatures != null && !this.supportedFeatures.isEmpty()) {
            StringBuilder sb = new StringBuilder("<");
            sb.append(namespacePre);
            sb.append(":SupportedFeatures>");
            for (Constants.OSCIFeatures feature : this.supportedFeatures) {
                sb.append("<");
                sb.append(namespacePre);
                sb.append(":Feature Key=\"" + feature.name() + "\"");
                sb.append(" Version=\"" + feature.getVersion() + "\">");
                sb.append("</");
                sb.append(namespacePre);
                sb.append(":Feature>");
            }
            sb.append("</");
            sb.append(namespacePre);
            sb.append(":SupportedFeatures>");
            out.write(sb.toString().getBytes());
        }
        out.write(("</" + namespacePre + ":" + Constants.HeaderTags.FeatureDescription.getElementName() + ">").getBytes(Constants.CHARSET_ENCODING));
    }
}

