/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.soapheader;

import de.osci.helper.Base64InputStream;
import de.osci.helper.ParserHelper;
import de.osci.helper.Tools;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Author;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Reader;
import de.osci.osci12.roles.Role;
import de.osci.osci12.soapheader.NonIntermediaryCertificatesH;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class NonIntermediaryCertificatesHBuilder
extends MessagePartParser {
    private static Logger log = LoggerFactory.getLogger(NonIntermediaryCertificatesHBuilder.class);
    private static final int CIPHER_CERTIFICATE_ORIGINATOR = 0;
    private static final int CIPHER_CERTIFICATE_OTHER_AUTHOR = 1;
    private static final int CIPHER_CERTIFICATE_ADDRESSEE = 2;
    private static final int CIPHER_CERTIFICATE_OTHER_READER = 3;
    private static final int SIGNATURE_CERTIFICATE_ORIGINATOR = 4;
    private static final int SIGNATURE_CERTIFICATE_OTHER_AUTHOR = 5;
    private static final int SIGNATURE_CERTIFICATE_ADDRESSEE = 6;
    private int[] check;
    private NonIntermediaryCertificatesH nic = null;
    private int typ;
    private Originator originator;
    private Addressee addressee;
    private Vector<Reader> reader = new Vector();
    private Vector<Author> authors = new Vector();
    private String tmpId;
    private String refId;
    private int msgTyp;
    private boolean changeOrgsAndAdds = false;

    public NonIntermediaryCertificatesHBuilder(OSCIMessageBuilder parentHandler, Attributes atts, int[] check) throws SAXException {
        super(parentHandler);
        parentHandler.addFoundMsgPartIds(atts.getValue("Id"), Constants.HeaderTags.NonIntermediaryCertificates.getNamespace().getUri() + ":" + Constants.HeaderTags.NonIntermediaryCertificates.getElementName());
        this.check = check;
        this.nic = new NonIntermediaryCertificatesH();
        if (atts.getValue("Id") != null) {
            this.nic.setRefID(atts.getValue("Id"));
        }
        this.msgTyp = this.msg.getMessageType();
        if (this.msgTyp == 48 || this.msgTyp == 144 || this.msgTyp == 128 || this.msgTyp == 49) {
            this.changeOrgsAndAdds = true;
        }
        OSCIMessage msg = parentHandler.getOSCIMessage();
        this.nic.setNSPrefixes(msg);
    }

    public NonIntermediaryCertificatesHBuilder(XMLReader xmlReader) throws SAXException {
        super(xmlReader, new OSCIMessageBuilder(null));
        this.msgTyp = 0;
        this.check = new int[]{-1, -1, -1, -1, -1, -1, -1};
        this.nic = new NonIntermediaryCertificatesH();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start-Element: " + localName);
        }
        if (localName.equals("CipherCertificateOriginator") && uri.equals(OSCI_XMLNS)) {
            this.typ = 0;
        } else if (localName.equals("CipherCertificateOtherAuthor") && uri.equals(OSCI_XMLNS)) {
            this.typ = 1;
        } else if (localName.equals("CipherCertificateAddressee") && uri.equals(OSCI_XMLNS)) {
            this.typ = 2;
        } else if (localName.equals("CipherCertificateOtherReader") && uri.equals(OSCI_XMLNS)) {
            this.typ = 3;
        } else if (localName.equals("SignatureCertificateOriginator") && uri.equals(OSCI_XMLNS)) {
            this.typ = 4;
        } else if (localName.equals("SignatureCertificateOtherAuthor") && uri.equals(OSCI_XMLNS)) {
            this.typ = 5;
        } else if (localName.equals("SignatureCertificateAddressee") && uri.equals(OSCI_XMLNS)) {
            this.typ = 6;
        } else if (localName.equals("X509Certificate") && uri.equals(DS_XMLNS)) {
            this.currentElement = new StringBuffer();
        } else if (!(localName.equals("X509Data") && uri.equals(DS_XMLNS) || localName.equals(Constants.HeaderTags.NonIntermediaryCertificates.getElementName()))) {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
        if (attributes.getValue("Id") != null) {
            this.refId = attributes.getValue("Id");
            if (this.refId.indexOf("_") >= 0) {
                this.tmpId = this.refId.substring(0, this.refId.indexOf(95));
            }
        }
        if (this.check[this.typ] == 0) {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("End-Element: " + localName);
        }
        if (ParserHelper.isElement(Constants.HeaderTags.NonIntermediaryCertificates, localName, uri)) {
            for (int i = 0; i < this.check.length; ++i) {
                if (this.check[i] <= 0) continue;
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": " + localName);
            }
            try {
                int i;
                this.nic.setCipherCertificatesOtherReaders(this.reader.toArray(new Reader[0]));
                Vector<Author> vec = new Vector<Author>();
                for (i = 0; i < this.authors.size(); ++i) {
                    if (!this.authors.get(i).hasCipherCertificate()) continue;
                    vec.add(this.authors.get(i));
                }
                this.nic.setCipherCertificatesOtherAuthors(vec.toArray(new Author[0]));
                vec = new Vector();
                for (i = 0; i < this.authors.size(); ++i) {
                    if (!((Role)this.authors.get(i)).hasSignatureCertificate()) continue;
                    vec.add(this.authors.get(i));
                }
                this.nic.setSignatureCertificatesOtherAuthors(vec.toArray(new Author[0]));
                if (this.msg != null) {
                    this.msg.addRole(this.originator);
                    this.msg.addRole(this.addressee);
                    if (this.msgTyp == 16) {
                        if (this.addressee != null) {
                            this.msg.dialogHandler.supplier = this.addressee;
                        }
                    } else if (this.msgTyp == 144) {
                        if (this.originator != null) {
                            if (this.originator.hasSignatureCertificate()) {
                                this.msg.dialogHandler.getSupplier().setSignatureCertificate(this.originator.getSignatureCertificate());
                            }
                            if (this.originator.hasCipherCertificate()) {
                                this.msg.dialogHandler.getSupplier().setCipherCertificate(this.originator.getCipherCertificate());
                            }
                        }
                    } else if (!this.changeOrgsAndAdds && this.msgTyp != 1 && this.msgTyp != 9 && this.originator != null) {
                        this.msg.dialogHandler.client = this.originator;
                    }
                    for (i = 0; i < this.authors.size(); ++i) {
                        this.msg.addRole(this.authors.get(i));
                    }
                    for (i = 0; i < this.reader.size(); ++i) {
                        this.msg.addRole(this.reader.get(i));
                    }
                    this.msg.nonIntermediaryCertificatesH = this.nic;
                }
                this.xmlReader.setContentHandler(this.parentHandler);
            }
            catch (OSCIRoleException ex) {
                log.error("Fehler im End-Element", (Throwable)ex);
                throw new SAXException(ex);
            }
        }
        if (localName.equals("X509Certificate") && uri.equals(DS_XMLNS)) {
            try {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(this.currentElement.toString().getBytes(Constants.CHARSET_ENCODING));
                Base64InputStream base64In = new Base64InputStream(byteStream);
                X509Certificate cert = Tools.createCertificate(base64In);
                if (this.typ == 0) {
                    if (this.msg != null && !this.changeOrgsAndAdds && this.msg.dialogHandler.getClient() instanceof Originator) {
                        this.originator = (Originator)this.msg.dialogHandler.getClient();
                    }
                    if (this.originator != null) {
                        if (!this.originator.hasCipherCertificate()) {
                            this.originator.setCipherCertificate(cert);
                        } else if (!this.originator.getCipherCertificate().equals(cert)) {
                            throw new IllegalStateException(DialogHandler.text.getString("not_matching_cipher_certs") + " Originator");
                        }
                    } else {
                        this.originator = new Originator((X509Certificate)null, cert);
                    }
                    if (this.tmpId != null) {
                        this.originator.id = this.tmpId;
                    }
                    this.originator.cipherRefId = this.refId;
                    this.nic.setCipherCertificateOriginator(this.originator);
                    this.check[0] = 0;
                } else if (this.typ == 1) {
                    Author au = new Author((X509Certificate)null, cert);
                    if (this.tmpId != null) {
                        au.id = this.tmpId;
                    }
                    au.cipherRefId = this.refId;
                    this.authors.add(au);
                    if (this.msg != null) {
                        this.msg.addRole(au);
                    }
                } else if (this.typ == 2) {
                    if (this.msg != null && !this.changeOrgsAndAdds && this.msg.dialogHandler.getClient() instanceof Addressee) {
                        this.addressee = (Addressee)this.msg.dialogHandler.getClient();
                    }
                    if (this.addressee != null) {
                        if (this.addressee.hasCipherCertificate()) {
                            this.addressee.setCipherCertificate(cert);
                        } else if (!this.addressee.getCipherCertificate().equals(cert)) {
                            throw new IllegalStateException(DialogHandler.text.getString("not_matching_cipher_certs") + " Addressee");
                        }
                    } else {
                        this.addressee = new Addressee((X509Certificate)null, cert);
                    }
                    if (this.tmpId != null) {
                        this.addressee.id = this.tmpId;
                    }
                    this.addressee.cipherRefId = this.refId;
                    this.nic.setCipherCertificateAddressee(this.addressee);
                    this.check[2] = 0;
                } else if (this.typ == 3) {
                    Reader rd = new Reader(cert);
                    if (this.tmpId != null) {
                        rd.id = this.tmpId;
                    }
                    rd.cipherRefId = this.refId;
                    this.reader.add(rd);
                    if (this.msg != null) {
                        this.msg.addRole(rd);
                    }
                } else if (this.typ == 4) {
                    if (this.originator == null) {
                        if (this.msg != null && !this.changeOrgsAndAdds && this.msg.dialogHandler.getClient() instanceof Originator) {
                            this.originator = (Originator)this.msg.dialogHandler.getClient();
                            this.originator.setSignatureCertificate(cert);
                        } else {
                            this.originator = new Originator(cert, (X509Certificate)null);
                        }
                    } else {
                        this.originator.setSignatureCertificate(cert);
                    }
                    if (this.tmpId != null) {
                        this.originator.id = this.tmpId;
                    }
                    this.originator.signatureRefId = this.refId;
                    this.nic.setSignatureCertificateOriginator(this.originator);
                    this.check[4] = 0;
                } else if (this.typ == 5) {
                    int i;
                    for (i = 0; i < this.authors.size(); ++i) {
                        if (!this.authors.get((int)i).id.equals(this.tmpId)) continue;
                        try {
                            this.authors.get(i).getSignatureCertificate();
                            if (this.tmpId == null) continue;
                            this.tmpId = this.tmpId + "0";
                            continue;
                        }
                        catch (OSCIRoleException ex) {
                            this.authors.get(i).setSignatureCertificate(cert);
                            this.authors.get((int)i).signatureRefId = this.refId;
                            break;
                        }
                    }
                    if (i == this.authors.size()) {
                        Author au = new Author(cert, (X509Certificate)null);
                        if (this.tmpId != null) {
                            au.id = this.tmpId;
                        }
                        au.signatureRefId = this.refId;
                        this.authors.add(au);
                        if (this.msg != null) {
                            this.msg.addRole(au);
                        }
                    }
                } else if (this.typ == 6) {
                    if (this.addressee == null) {
                        this.addressee = new Addressee(cert, (X509Certificate)null);
                    } else {
                        this.addressee.setSignatureCertificate(cert);
                    }
                    if (this.tmpId != null) {
                        this.addressee.id = this.tmpId;
                    }
                    this.addressee.signatureRefId = this.refId;
                    this.nic.setSignatureCertificateAddressee(this.addressee);
                    this.check[6] = 0;
                }
            }
            catch (Exception ex) {
                log.error("Fehler im End-Element", (Throwable)ex);
                throw new SAXException(ex);
            }
            this.tmpId = null;
        }
        this.typ = -1;
        this.currentElement = null;
    }

    public NonIntermediaryCertificatesH getNonIntermediaryCertificatesH() {
        return this.nic;
    }

    public static NonIntermediaryCertificatesH createFromXmlBytes(byte[] xmlBytes) throws SAXException {
        try {
            SAXParser parser = ParserHelper.getNewSAXParser();
            XMLReader reader = parser.getXMLReader();
            ParserHelper.setFeatures(reader);
            NonIntermediaryCertificatesHBuilder nicBuilder = new NonIntermediaryCertificatesHBuilder(reader);
            parser.parse(new InputSource(new ByteArrayInputStream(xmlBytes)), (DefaultHandler)nicBuilder);
            return nicBuilder.getNonIntermediaryCertificatesH();
        }
        catch (IOException | ParserConfigurationException ex) {
            log.error("Allgemeiner Fehler beim Parsen des eingelesenen NonIntermediaryCertificatesH-Elements");
            throw new SAXException(ex);
        }
    }
}

