/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.soapheader;

import de.osci.osci12.common.Constants;
import de.osci.osci12.soapheader.HeaderEntry;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsciH
extends HeaderEntry {
    private static Logger log = LoggerFactory.getLogger(OsciH.class);
    String name;
    String data;
    String namespace;

    public OsciH(String name, String data) {
        this.namespace = this.osciNSPrefix;
        this.name = name;
        this.data = data;
    }

    public OsciH(String name, String data, String namespace) {
        this.namespace = this.osciNSPrefix;
        this.name = name;
        this.data = data;
        this.namespace = namespace;
    }

    @Override
    public String getRefID() {
        return this.name.toLowerCase();
    }

    @Override
    public void writeXML(OutputStream out) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("RefID: " + this.getRefID());
        }
        out.write(("<" + this.namespace + ":" + this.name).getBytes(Constants.CHARSET_ENCODING));
        if (this.namespace.equals(this.osciNSPrefix)) {
            out.write(this.ns);
        } else {
            out.write(this.ns2017);
        }
        out.write((" Id=\"" + this.getRefID() + "\" " + this.soapNSPrefix + ":actor=\"http://schemas.xmlsoap.org/soap/actor/next\" " + this.soapNSPrefix + ":mustUnderstand=\"1\">").getBytes(Constants.CHARSET_ENCODING));
        out.write(this.data.getBytes(Constants.CHARSET_ENCODING));
        out.write(("</" + this.namespace + ":" + this.name + ">").getBytes(Constants.CHARSET_ENCODING));
    }
}

