/*
 * Decompiled with CFR 0.152.
 */
package de.otto.wickettester;

import de.otto.wickettester.ComponentMatcher;
import de.otto.wickettester.EnabledComponentMatcher;
import de.otto.wickettester.HavingChildComponentMatcher;
import de.otto.wickettester.HavingDirectChildComponentMatcher;
import de.otto.wickettester.HavingDirectParentComponentMatcher;
import de.otto.wickettester.HavingSiblingComponentMatcher;
import de.otto.wickettester.ModelObjectComponentMatcher;
import de.otto.wickettester.NegatingComponentMatcher;
import de.otto.wickettester.TypeComponentMatcher;
import de.otto.wickettester.VisibleComponentMatcher;
import de.otto.wickettester.WicketIdComponentMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;

public class ComponentMatchers {
    public static <T extends Component> ComponentMatcherBuilder<T> builder() {
        return new ComponentMatcherBuilder();
    }

    public static <T extends Component> ComponentMatcherBuilder<T> type(Class<T> componentClass) {
        return ComponentMatchers.builder().type(componentClass);
    }

    public static class ComponentMatcherBuilder<T extends Component> {
        private final List<ComponentMatcher<T, T>> visitors = new LinkedList<ComponentMatcher<T, T>>();

        public ComponentMatcherBuilder<T> wicketId(String wicketId) {
            this.visitors.add(new WicketIdComponentMatcher(wicketId));
            return this;
        }

        public ComponentMatcherBuilder<T> visible() {
            this.visitors.add(new VisibleComponentMatcher());
            return this;
        }

        public ComponentMatcherBuilder<T> enabled() {
            this.visitors.add(new EnabledComponentMatcher());
            return this;
        }

        public ComponentMatcherBuilder<T> type(Class<T> componentClass) {
            this.visitors.add(new TypeComponentMatcher<T>(componentClass));
            return this;
        }

        public ComponentMatcherBuilder<T> visitedBy(ComponentMatcher<T, T> visitor) {
            this.visitors.add(visitor);
            return this;
        }

        public <MT extends Component> ComponentMatcherBuilder<T> havingChild(ComponentMatcherBuilder<MT> builder) {
            this.visitors.add(new HavingChildComponentMatcher(builder.build()));
            return this;
        }

        public <MT extends Component> ComponentMatcherBuilder<T> havingDirectChild(ComponentMatcherBuilder<MT> builder) {
            this.visitors.add(new HavingDirectChildComponentMatcher(builder.build()));
            return this;
        }

        public <MT extends Component> ComponentMatcherBuilder<T> havingSibling(ComponentMatcherBuilder<MT> builder) {
            this.visitors.add(new HavingSiblingComponentMatcher(builder.build()));
            return this;
        }

        public <MT extends MarkupContainer> ComponentMatcherBuilder<T> havingDirectParent(ComponentMatcherBuilder<MT> builder) {
            this.visitors.add(new HavingDirectParentComponentMatcher(builder.build()));
            return this;
        }

        public ComponentMatcherBuilder<T> modelObject(Object modelObject) {
            this.visitors.add(new ModelObjectComponentMatcher(modelObject));
            return this;
        }

        public ComponentMatcherBuilder<T> not(ComponentMatcherBuilder<T> builder) {
            this.visitors.add(new NegatingComponentMatcher<T>(builder.build()));
            return this;
        }

        public ComponentMatcher<T, T> build() {
            return new JoiningComponentMatcher(this.visitors.toArray(new ComponentMatcher[this.visitors.size()]));
        }

        public CollectingComponentMatcher<T, T> buildCollecting() {
            return new CollectingComponentMatcher<T, T>(this.build());
        }

        public Object criteriaAsString() {
            LinkedList<String> criteria = new LinkedList<String>();
            for (ComponentMatcher<T, T> visitor : this.visitors) {
                criteria.add(visitor.criterionAsString());
            }
            return StringUtils.join(criteria, (String)" and ");
        }

        private static class AllComponentMatcher<T extends Component>
        implements ComponentMatcher<T, T> {
            private AllComponentMatcher() {
            }

            @Override
            public T match(T component) {
                return component;
            }

            @Override
            public String criterionAsString() {
                return "being a component";
            }
        }

        private static class JoiningComponentMatcher<T extends Component>
        implements ComponentMatcher<T, T> {
            private final List<ComponentMatcher<T, T>> componentMatchers = new LinkedList(Collections.singleton(new AllComponentMatcher()));

            public JoiningComponentMatcher(ComponentMatcher<T, T> ... componentMatchers) {
                this.componentMatchers.addAll(Arrays.asList(componentMatchers));
            }

            @Override
            public T match(T component) {
                for (ComponentMatcher<T, T> visitor : this.componentMatchers) {
                    Component visited = (Component)visitor.match(component);
                    if (visited != null) continue;
                    return null;
                }
                return component;
            }

            @Override
            public String criterionAsString() {
                LinkedList<String> criteria = new LinkedList<String>();
                for (ComponentMatcher<T, T> visitor : this.componentMatchers) {
                    criteria.add(visitor.criterionAsString());
                }
                return StringUtils.join(criteria, (String)" and ");
            }
        }

        static class CollectingComponentMatcher<T extends Component, R>
        implements ComponentMatcher<T, R> {
            private final List<R> bucket;
            private final ComponentMatcher<T, R> componentMatcher;

            public CollectingComponentMatcher(ComponentMatcher<T, R> matcher) {
                this.componentMatcher = matcher;
                this.bucket = new ArrayList<R>();
            }

            public void addToBucket(R element) {
                this.bucket.add(element);
            }

            public List<R> getBucket() {
                return this.bucket;
            }

            @Override
            public R match(T component) {
                R visited = this.componentMatcher.match(component);
                if (visited != null) {
                    this.addToBucket(visited);
                }
                return null;
            }

            @Override
            public String criterionAsString() {
                return "a list of components";
            }
        }
    }
}

