/*
 * Decompiled with CFR 0.152.
 */
package de.otto.wickettester;

import de.otto.wickettester.ComponentMatcher;
import de.otto.wickettester.ComponentMatchers;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.TagTester;
import org.apache.wicket.util.tester.WicketTester;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visits;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;

public class EnhancedWicketTester
extends WicketTester {
    public EnhancedWicketTester() {
    }

    public EnhancedWicketTester(WebApplication application) {
        super(application);
    }

    public static <T extends Component, R> R visitComponentTree(MarkupContainer root, final ComponentMatcher<T, R> matcher) {
        Object res = Visits.visitChildren((Iterable)root, (IVisitor)new IVisitor<T, R>(){

            public void component(T component, IVisit<R> visit) {
                Object result = matcher.match(component);
                if (result != null) {
                    visit.stop(result);
                }
            }
        });
        return (R)res;
    }

    public <T extends Component> List<T> getChildrenMatching(MarkupContainer root, ComponentMatchers.ComponentMatcherBuilder<T> builder, ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer> ... parentBuilders) {
        ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer>[] realParentBuilders = this.cleanup(parentBuilders);
        if (realParentBuilders.length == 0) {
            ComponentMatchers.ComponentMatcherBuilder.CollectingComponentMatcher<T, T> matcher = builder.buildCollecting();
            EnhancedWicketTester.visitComponentTree(root, matcher);
            return matcher.getBucket();
        }
        List<? extends MarkupContainer> parentsMatching = this.getChildrenMatching(root, realParentBuilders[0], this.tail(realParentBuilders));
        LinkedList<T> childrenMatching = new LinkedList<T>();
        for (Component component : parentsMatching) {
            ComponentMatchers.ComponentMatcherBuilder.CollectingComponentMatcher<T, T> matcher = builder.buildCollecting();
            EnhancedWicketTester.visitComponentTree((MarkupContainer)component, matcher);
            childrenMatching.addAll(matcher.getBucket());
        }
        return childrenMatching;
    }

    private ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer>[] cleanup(ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer>[] builders) {
        if (builders == null || builders.length == 0) {
            return new ComponentMatchers.ComponentMatcherBuilder[0];
        }
        Object[] buildersWip = builders;
        while (ArrayUtils.contains((Object[])buildersWip, null)) {
            buildersWip = (ComponentMatchers.ComponentMatcherBuilder[])ArrayUtils.removeElement((Object[])builders, null);
        }
        return buildersWip;
    }

    private ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer>[] tail(ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer>[] arr) {
        return (ComponentMatchers.ComponentMatcherBuilder[])ArrayUtils.remove((Object[])arr, (int)0);
    }

    public <T extends Component> List<T> getChildrenMatching(MarkupContainer root, ComponentMatchers.ComponentMatcherBuilder<T> builder) {
        return this.getChildrenMatching(root, builder, new ComponentMatchers.ComponentMatcherBuilder[]{null});
    }

    public <T extends Component> List<T> getChildrenMatching(ComponentMatchers.ComponentMatcherBuilder<T> builder, ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer> ... parentBuilders) {
        return this.getChildrenMatching((MarkupContainer)this.getLastRenderedPage(), builder, parentBuilders);
    }

    public <T extends Component> List<T> getChildrenMatching(ComponentMatchers.ComponentMatcherBuilder<T> builder) {
        return this.getChildrenMatching(builder, new ComponentMatchers.ComponentMatcherBuilder[]{null});
    }

    public <T extends Component> T getChildMatching(MarkupContainer root, ComponentMatchers.ComponentMatcherBuilder<T> builder, ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer> ... parentBuilders) {
        List<T> children = this.getChildrenMatching(root, builder, parentBuilders);
        Assert.assertEquals((int)children.size(), (int)1, (String)String.format("Did not find exactly one child %s", builder.criteriaAsString()));
        return (T)((Component)children.get(0));
    }

    public <T extends Component> T getChildMatching(MarkupContainer root, ComponentMatchers.ComponentMatcherBuilder<T> builder) {
        return this.getChildMatching(root, builder, new ComponentMatchers.ComponentMatcherBuilder[]{null});
    }

    public <T extends Component> T getChildMatching(ComponentMatchers.ComponentMatcherBuilder<T> builder, ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer> ... parentBuilders) {
        return this.getChildMatching((MarkupContainer)this.getLastRenderedPage(), builder, parentBuilders);
    }

    public <T extends Component> T getChildMatching(ComponentMatchers.ComponentMatcherBuilder<T> builder) {
        return this.getChildMatching(builder, new ComponentMatchers.ComponentMatcherBuilder[]{null});
    }

    public <T extends Component> T getFirstChildMatching(MarkupContainer root, ComponentMatchers.ComponentMatcherBuilder<T> builder, ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer> ... parentBuilders) {
        List<T> children = this.getChildrenMatching(root, builder, parentBuilders);
        Assert.assertTrue((children.size() > 0 ? 1 : 0) != 0, (String)String.format("Did not find at least one child %s", builder.criteriaAsString()));
        return (T)((Component)children.get(0));
    }

    public <T extends Component> T getFirstChildMatching(ComponentMatchers.ComponentMatcherBuilder<T> builder, ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer> ... parentBuilders) {
        return this.getFirstChildMatching((MarkupContainer)this.getLastRenderedPage(), builder, parentBuilders);
    }

    public <T extends Component> T getFirstChildMatching(MarkupContainer root, ComponentMatchers.ComponentMatcherBuilder<T> builder) {
        return this.getFirstChildMatching(root, builder, new ComponentMatchers.ComponentMatcherBuilder[]{null});
    }

    public <T extends Component> T getFirstChildMatching(ComponentMatchers.ComponentMatcherBuilder<T> builder) {
        return this.getFirstChildMatching(builder, new ComponentMatchers.ComponentMatcherBuilder[]{null});
    }

    public String getPathRelativeToRoot(Component root, Component component) {
        String rootPath = root.getPageRelativePath();
        String componentPath = component.getPageRelativePath();
        Assert.assertTrue((boolean)componentPath.startsWith(rootPath), (String)"Component is not a child of the root component");
        if (rootPath.length() == componentPath.length()) {
            return "";
        }
        return StringUtils.stripStart((String)componentPath.substring(rootPath.length()), (String)":");
    }

    public String getPathRelativeToPage(Component component) {
        return this.getPathRelativeToRoot((Component)this.getLastRenderedPage(), component);
    }

    public TagTester getTagTesterByComponent(Component component) {
        String[] pathSegments = component.getPath().split(String.valueOf(':'));
        String[] tail = Arrays.copyOfRange(pathSegments, 1, pathSegments.length);
        return TagTester.createTagByAttribute((String)this.getLastResponseAsString(), (String)"wicketpath", (String)this.getWicketPath(tail));
    }

    public TagTester getTagTesterByComponentMatcher(ComponentMatchers.ComponentMatcherBuilder<? extends Component> builder, ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer> ... parentBuilders) {
        return this.getTagTesterByComponent(this.getChildMatching(builder, parentBuilders));
    }

    private String getWicketPath(String[] tail) {
        for (int i = 0; i < tail.length; ++i) {
            tail[i] = tail[i].replace("_", "__");
        }
        return StringUtils.join((Object[])tail, (String)"_");
    }

    public void assertModelValue(Component component, Object expectedModelObject) {
        MatcherAssert.assertThat((Object)component.getDefaultModelObject(), (Matcher)Matchers.equalTo((Object)expectedModelObject));
    }

    public void assertModelValue(Object expectedModelObject, ComponentMatchers.ComponentMatcherBuilder<? extends Component> builder, ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer> ... parentBuilders) {
        MatcherAssert.assertThat((Object)this.getChildMatching(builder, parentBuilders).getDefaultModelObject(), (Matcher)Matchers.equalTo((Object)expectedModelObject));
    }

    public void assertVisible(Component component) {
        this.assertVisible(this.getPathRelativeToPage(component));
    }

    public void assertVisible(ComponentMatchers.ComponentMatcherBuilder<? extends Component> builder, ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer> ... parentBuilders) {
        this.assertVisible(this.getChildMatching(builder, parentBuilders));
    }

    public void assertFeedback(ComponentMatchers.ComponentMatcherBuilder<? extends Component> builder, Serializable ... feedback) {
        this.assertFeedback(this.getPathRelativeToPage(this.getChildMatching(builder)), feedback);
    }

    public FormTester newFormTester(Form<?> form) {
        return this.newFormTester(this.getPathRelativeToPage((Component)form));
    }

    public FormTester newFormTester(ComponentMatchers.ComponentMatcherBuilder<? extends Form> builder, ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer> ... parentBuilders) {
        return this.newFormTester(this.getChildMatching(builder, parentBuilders));
    }

    public void assertInvisible(Label component) {
        this.assertInvisible(this.getPathRelativeToPage((Component)component));
    }

    public void clickLink(ComponentMatchers.ComponentMatcherBuilder<? extends Component> builder, ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer> ... parentBuilders) {
        this.clickLink(this.getChildMatching(builder, parentBuilders));
    }

    public void executeAjaxEvent(String event, ComponentMatchers.ComponentMatcherBuilder<? extends Component> builder, ComponentMatchers.ComponentMatcherBuilder<? extends MarkupContainer> ... parentBuilders) {
        this.executeAjaxEvent(this.getChildMatching(builder, parentBuilders), event);
    }
}

