/*
 * Decompiled with CFR 0.152.
 */
package de.otto.wickettester;

import de.otto.wickettester.ComponentMatcher;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;

public class HavingDirectChildComponentMatcher<T extends Component, CT extends Component>
implements ComponentMatcher<T, T> {
    private final ComponentMatcher<CT, CT> matcher;

    public HavingDirectChildComponentMatcher(ComponentMatcher<CT, CT> matcher) {
        this.matcher = matcher;
    }

    @Override
    public T match(T component) {
        if (!(component instanceof MarkupContainer)) {
            return null;
        }
        for (Component directChild : (MarkupContainer)component) {
            Component result = (Component)this.matcher.match(directChild);
            if (result == null) continue;
            return component;
        }
        return null;
    }

    @Override
    public String criterionAsString() {
        return String.format("having a direct child (%s)", this.matcher.criterionAsString());
    }
}

