/*
 * Decompiled with CFR 0.152.
 */
package de.otto.wickettester;

import de.otto.wickettester.ComponentMatcher;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;

public class HavingSiblingComponentMatcher<T extends Component, CT extends Component>
implements ComponentMatcher<T, T> {
    private final ComponentMatcher<CT, CT> matcher;

    public HavingSiblingComponentMatcher(ComponentMatcher<CT, CT> matcher) {
        this.matcher = matcher;
    }

    @Override
    public T match(T component) {
        if (component == null) {
            return null;
        }
        MarkupContainer parent = component.getParent();
        if (parent == null) {
            return null;
        }
        Component toReturn = null;
        for (Component next : parent) {
            if (this.matcher.match(next) == null) continue;
            toReturn = next;
        }
        return (T)toReturn;
    }

    @Override
    public String criterionAsString() {
        return String.format("having a direct parent (%s)", this.matcher.criterionAsString());
    }
}

