/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup;

import de.otto.jlineup.GlobalOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalOptions {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalOptions.class);
    private static final String DEFAULT_LAMBDA_FUNCTION_NAME = "jlineup-lambda";
    private static final String DEFAULT_LAMBDA_AWS_PROFILE = "default";
    private static final String DEFAULT_LAMBDA_S3_BUCKET = "jlineup-lambda";
    private static final String DEFAULT_CROP_LAST_SCREENSHOT = "false";
    private static final Map<GlobalOption, String> options = new HashMap<GlobalOption, String>();

    private static void loadOption(Properties appProps, String key, String property, String defaultValue, GlobalOption option) {
        if (System.getenv(key) != null) {
            options.put(option, System.getenv(key));
        } else if (appProps.getProperty(property) != null) {
            options.put(option, appProps.getProperty(property));
        } else {
            options.put(option, defaultValue);
        }
    }

    public static void setOption(GlobalOption option, String value) {
        options.put(option, value);
    }

    public static String getOption(GlobalOption option) {
        return options.get((Object)option);
    }

    public static String asString() {
        return "GlobalOptions{options=" + String.join((CharSequence)", ", options.entrySet().stream().map(e -> String.valueOf(e.getKey()) + ": " + (String)e.getValue()).toList()) + "}";
    }

    static {
        Properties appProps = new Properties();
        try {
            appProps.load(GlobalOptions.class.getResourceAsStream("/settings.properties"));
        }
        catch (Exception e) {
            LOG.debug("No settings found");
        }
        GlobalOptions.loadOption(appProps, "JLINEUP_LAMBDA_FUNCTION_NAME", "jlineup.lambda.function-name", "jlineup-lambda", GlobalOption.JLINEUP_LAMBDA_FUNCTION_NAME);
        GlobalOptions.loadOption(appProps, "JLINEUP_AWS_PROFILE", "jlineup.lambda.aws-profile", DEFAULT_LAMBDA_AWS_PROFILE, GlobalOption.JLINEUP_LAMBDA_AWS_PROFILE);
        GlobalOptions.loadOption(appProps, "JLINEUP_LAMBDA_S3_BUCKET", "jlineup.lambda.s3-bucket", "jlineup-lambda", GlobalOption.JLINEUP_LAMBDA_S3_BUCKET);
        GlobalOptions.loadOption(appProps, "JLINEUP_CROP_LAST_SCREENSHOT", "jlineup.crop-last-screenshot", DEFAULT_CROP_LAST_SCREENSHOT, GlobalOption.JLINEUP_CROP_LAST_SCREENSHOT);
        GlobalOptions.loadOption(appProps, "JLINEUP_CHROME_VERSION", "jlineup.chrome-version", null, GlobalOption.JLINEUP_CHROME_VERSION);
        GlobalOptions.loadOption(appProps, "JLINEUP_FIREFOX_VERSION", "jlineup.firefox-version", null, GlobalOption.JLINEUP_FIREFOX_VERSION);
    }
}

