/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup;

import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.Utils;
import de.otto.jlineup.browser.Browser;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.JobConfigValidator;
import de.otto.jlineup.config.RunStep;
import de.otto.jlineup.exceptions.ValidationError;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.image.ImageService;
import de.otto.jlineup.report.HTMLReportWriter;
import de.otto.jlineup.report.JSONReportWriter;
import de.otto.jlineup.report.JSONReportWriter_V1;
import de.otto.jlineup.report.JSONReportWriter_V2;
import de.otto.jlineup.report.Report;
import de.otto.jlineup.report.ReportGenerator;
import de.otto.jlineup.report.ReportGeneratorV2;
import de.otto.jlineup.report.ReportV2;
import de.otto.jlineup.report.ScreenshotComparisonResult;
import de.otto.jlineup.report.ScreenshotsComparator;
import de.otto.jlineup.report.UrlReport;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class JLineupRunner {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String REPORT_LOG_NAME_KEY = "reportlogname";
    public static final String LOGFILE_NAME = "jlineup.log";
    private final JobConfig jobConfig;
    private final RunStepConfig runStepConfig;

    public JLineupRunner(JobConfig jobConfig, RunStepConfig runStepConfig) throws ValidationError {
        this.jobConfig = jobConfig;
        this.runStepConfig = runStepConfig;
        this.validateConfig();
    }

    public boolean run() {
        FileService fileService = new FileService(this.runStepConfig, this.jobConfig);
        ImageService imageService = new ImageService();
        HTMLReportWriter htmlReportWriter = new HTMLReportWriter(fileService);
        if (this.runStepConfig.getStep() == RunStep.before || this.runStepConfig.getStep() == RunStep.after_only) {
            try {
                fileService.createWorkingDirectoryIfNotExists();
                fileService.createOrClearReportDirectory(this.runStepConfig.isKeepExisting());
                fileService.createOrClearScreenshotsDirectory(this.runStepConfig.isKeepExisting());
                htmlReportWriter.writeNotFinishedReport(this.runStepConfig, this.jobConfig);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        MDC.put((String)REPORT_LOG_NAME_KEY, (String)BrowserUtils.getFullPathToLogFile(this.runStepConfig));
        LOG.info("JLineup run started for step '{}'", (Object)this.runStepConfig.getStep());
        if (this.runStepConfig.getStep() == RunStep.before || this.runStepConfig.getStep() == RunStep.after || this.runStepConfig.getStep() == RunStep.after_only) {
            BrowserUtils browserUtils = new BrowserUtils();
            try (Browser browser = new Browser(this.runStepConfig, this.jobConfig, fileService, browserUtils);){
                browser.runSetupAndTakeScreenshots();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            if (this.runStepConfig.getStep() == RunStep.after || this.runStepConfig.getStep() == RunStep.compare) {
                ScreenshotsComparator screenshotsComparator = new ScreenshotsComparator(this.runStepConfig, this.jobConfig, fileService, imageService);
                Map<String, List<ScreenshotComparisonResult>> comparisonResults = screenshotsComparator.compare();
                ReportGenerator reportGenerator = new ReportGenerator();
                ReportGeneratorV2 reportGeneratorV2 = new ReportGeneratorV2(fileService);
                Report report = reportGenerator.generateReport(comparisonResults, this.jobConfig);
                ReportV2 reportV2 = reportGeneratorV2.generateReport(comparisonResults, this.jobConfig);
                JSONReportWriter jsonReportWriter = Utils.shouldUseLegacyReportFormat(this.jobConfig) ? new JSONReportWriter_V1(fileService) : new JSONReportWriter_V2(fileService);
                jsonReportWriter.writeComparisonReportAsJson(report);
                htmlReportWriter.writeReport(report);
                htmlReportWriter.writeReportV2(reportV2);
                Set<Map.Entry<String, UrlReport>> urlReports = report.screenshotComparisonsForUrl.entrySet();
                for (Map.Entry<String, UrlReport> urlReport : urlReports) {
                    LOG.info("Sum of screenshot differences for {}: {} ({} %)", new Object[]{urlReport.getKey(), urlReport.getValue().summary.differenceSum, Math.round(urlReport.getValue().summary.differenceSum * 100.0)});
                    LOG.info("Max difference of a single screenshot for {}: {} ({} %)", new Object[]{urlReport.getKey(), urlReport.getValue().summary.differenceMax, Math.round(urlReport.getValue().summary.differenceMax * 100.0)});
                    LOG.info("Accepted different pixels for {}: {}", (Object)urlReport.getKey(), (Object)urlReport.getValue().summary.acceptedDifferentPixels);
                }
                LOG.info("Sum of overall screenshot differences: {} ({} %)", (Object)report.summary.differenceSum, (Object)Math.round(report.summary.differenceSum * 100.0));
                LOG.info("Max difference of a single screenshot: {} ({} %)", (Object)report.summary.differenceMax, (Object)Math.round(report.summary.differenceMax * 100.0));
                if (!Utils.shouldUseLegacyReportFormat(this.jobConfig) && JLineupRunner.isDetectedDifferenceGreaterThanMaxDifference(urlReports, this.jobConfig)) {
                    LOG.info("JLineup finished. There was a difference between before and after. Return code is 1.");
                    return false;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.info("JLineup run finished for step '{}'", (Object)this.runStepConfig.getStep());
        MDC.remove((String)REPORT_LOG_NAME_KEY);
        return true;
    }

    static boolean isDetectedDifferenceGreaterThanMaxDifference(Set<Map.Entry<String, UrlReport>> urlReports, JobConfig jobConfig) {
        for (Map.Entry<String, UrlReport> urlReport : urlReports) {
            if (jobConfig.urls == null || !(urlReport.getValue().summary.differenceMax > jobConfig.urls.get((Object)urlReport.getKey()).maxDiff)) continue;
            return true;
        }
        return false;
    }

    private void validateConfig() throws ValidationError {
        JobConfigValidator.validateJobConfig(this.jobConfig);
    }
}

