/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup;

import de.otto.jlineup.browser.BrowserStep;
import de.otto.jlineup.config.RunStep;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RunStepConfig {
    private final String reportDirectory;
    private final String workingDirectory;
    private final String screenshotsDirectory;
    private final RunStep step;
    private final Map<String, String> urlReplacements;
    private final List<String> chromeParameters;
    private final List<String> firefoxParameters;
    private final String webDriverCachePath;
    private final boolean keepExisting;
    private final String refreshUrl;
    private final boolean cleanupProfile;

    private RunStepConfig(Builder builder) {
        this.reportDirectory = builder.reportDirectory;
        this.workingDirectory = builder.workingDirectory;
        this.screenshotsDirectory = builder.screenshotsDirectory;
        this.step = builder.step;
        this.urlReplacements = builder.urlReplacements;
        this.chromeParameters = builder.chromeParameters;
        this.firefoxParameters = builder.firefoxParameters;
        this.webDriverCachePath = builder.webDriverCachePath;
        this.keepExisting = builder.keepExisting;
        this.refreshUrl = builder.refreshUrl;
        this.cleanupProfile = builder.cleanupProfile;
    }

    public static Builder runStepConfigBuilder() {
        return new Builder();
    }

    public static Builder copyOfBuilder(RunStepConfig config) {
        return new Builder(config);
    }

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getScreenshotsDirectory() {
        return this.screenshotsDirectory;
    }

    public RunStep getStep() {
        return this.step;
    }

    public BrowserStep getBrowserStep() {
        return this.step.toBrowserStep();
    }

    public Map<String, String> getUrlReplacements() {
        return this.urlReplacements;
    }

    public List<String> getChromeParameters() {
        return this.chromeParameters;
    }

    public List<String> getFirefoxParameters() {
        return this.firefoxParameters;
    }

    public String getWebDriverCachePath() {
        return this.webDriverCachePath;
    }

    public boolean isKeepExisting() {
        return this.keepExisting;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public boolean isCleanupProfile() {
        return this.cleanupProfile;
    }

    public static final class Builder {
        private String reportDirectory;
        private String workingDirectory;
        private String screenshotsDirectory;
        private List<String> chromeParameters = Collections.emptyList();
        private List<String> firefoxParameters = Collections.emptyList();
        private Map<String, String> urlReplacements = Collections.emptyMap();
        private RunStep step;
        private String webDriverCachePath;
        private boolean keepExisting;
        private String refreshUrl;
        private boolean cleanupProfile;

        private Builder() {
        }

        private Builder(RunStepConfig copy) {
            this.reportDirectory = copy.getReportDirectory();
            this.workingDirectory = copy.getWorkingDirectory();
            this.screenshotsDirectory = copy.getScreenshotsDirectory();
            this.step = copy.getStep();
            this.urlReplacements = copy.getUrlReplacements();
            this.chromeParameters = copy.getChromeParameters();
            this.firefoxParameters = copy.getFirefoxParameters();
            this.webDriverCachePath = copy.getWebDriverCachePath();
            this.keepExisting = copy.isKeepExisting();
            this.refreshUrl = copy.getRefreshUrl();
            this.cleanupProfile = copy.isCleanupProfile();
        }

        public Builder withReportDirectory(String val) {
            this.reportDirectory = val;
            return this;
        }

        public Builder withWorkingDirectory(String val) {
            this.workingDirectory = val;
            return this;
        }

        public Builder withScreenshotsDirectory(String val) {
            this.screenshotsDirectory = val;
            return this;
        }

        public Builder withStep(RunStep val) {
            this.step = val;
            return this;
        }

        public Builder withFirefoxParameters(List<String> val) {
            this.firefoxParameters = val;
            return this;
        }

        public Builder withChromeParameters(List<String> val) {
            this.chromeParameters = val;
            return this;
        }

        public Builder withUrlReplacements(Map<String, String> val) {
            this.urlReplacements = val;
            return this;
        }

        public Builder withWebDriverCachePath(String val) {
            this.webDriverCachePath = val;
            return this;
        }

        public Builder withKeepExistingFiles(boolean val) {
            this.keepExisting = val;
            return this;
        }

        public Builder withRefreshUrl(String val) {
            this.refreshUrl = val;
            return this;
        }

        public Builder withCleanupProfile(boolean val) {
            this.cleanupProfile = val;
            return this;
        }

        public RunStepConfig build() {
            return new RunStepConfig(this);
        }
    }
}

