/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import com.fasterxml.jackson.annotation.JsonCreator;
import de.otto.jlineup.GlobalOption;
import de.otto.jlineup.GlobalOptions;
import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.Utils;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.browser.CloudBrowser;
import de.otto.jlineup.browser.CloudBrowserFactory;
import de.otto.jlineup.browser.JLineupHttpClient;
import de.otto.jlineup.browser.LogErrorChecker;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.DeviceConfig;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.RunStep;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.file.FileUtils;
import de.otto.jlineup.image.ImageService;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.graalvm.nativeimage.ImageInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Browser
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int THREAD_POOL_SUBMIT_SHUFFLE_TIME_IN_MS = 233;
    public static final int DEFAULT_SLEEP_AFTER_SCROLL_MILLIS = 50;
    public static final int DEFAULT_IMPLICIT_WAIT_TIME_IN_SECONDS = 60;
    public static final String JLINEUP_SLEEP_JS_OPENER = "jlineup.sleep";
    static final String JS_HIDE_IMAGES_CALL = "document.querySelectorAll(\"img\").forEach(img => img.style.visibility=\"hidden\");";
    static final String JS_DOCUMENT_HEIGHT_CALL = "return Math.max( document.body.scrollHeight, document.body.offsetHeight, document.documentElement.clientHeight, document.documentElement.scrollHeight, document.documentElement.offsetHeight );";
    static final String JS_CLIENT_VIEWPORT_HEIGHT_CALL = "return window.innerHeight";
    static final String JS_SET_LOCAL_STORAGE_CALL = "localStorage.setItem('%s','%s')";
    static final String JS_SET_SESSION_STORAGE_CALL = "sessionStorage.setItem('%s','%s')";
    static final String JS_SCROLL_TO_CALL = "window.scrollTo(0,%d)";
    static final String JS_SCROLL_TO_TOP_CALL = "window.scrollTo(0, 0);";
    static final String JS_RETURN_DOCUMENT_FONTS_SIZE_CALL = "return document.fonts.size;";
    static final String JS_RETURN_DOCUMENT_FONTS_STATUS_LOADED_CALL = "return document.fonts.status === 'loaded';";
    static final String JS_GET_USER_AGENT_CALL = "return navigator.userAgent;";
    static final String JS_GET_DOM_CALL = "return document.getElementsByTagName('body')[0].innerHTML;";
    static final String JS_REMOVE_FROM_DOM_CALL = "document.querySelectorAll('%s').forEach(el => el.remove());";
    static final String JS_CHECK_FOR_ELEMENT_CALL = "return document.querySelector('%s') !== null;";
    static final String JS_GET_DEVICE_PIXEL_RATIO_CALL = "return window.devicePixelRatio;";
    static final String JS_GET_BODY_COLOR_CALL = "return window.getComputedStyle(document.body).getPropertyValue('background-color').match(/\\d+/g);";
    private final JobConfig jobConfig;
    private final FileService fileService;
    private final BrowserUtils browserUtils;
    private final RunStepConfig runStepConfig;
    private final LogErrorChecker logErrorChecker;
    private boolean cloudBrowserUsed = false;
    private final ExecutorService threadPool;
    private final ConcurrentHashMap<String, WebDriver> webDrivers = new ConcurrentHashMap();
    private final AtomicBoolean shutdownCalled = new AtomicBoolean(false);
    private final AtomicBoolean printVersion = new AtomicBoolean(true);
    private final ExpectedCondition<Boolean> fontsLoaded = driver -> {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWebDriver();
        Long fontsLoadedCount = (Long)javascriptExecutor.executeScript(JS_RETURN_DOCUMENT_FONTS_SIZE_CALL, new Object[0]);
        Boolean fontsLoaded = (Boolean)javascriptExecutor.executeScript(JS_RETURN_DOCUMENT_FONTS_STATUS_LOADED_CALL, new Object[0]);
        LOG.debug("Amount of fonts in document: {}", (Object)fontsLoadedCount);
        LOG.debug("Fonts loaded: {} ", (Object)fontsLoaded);
        return fontsLoaded;
    };

    public Browser(RunStepConfig runStepConfig, JobConfig jobConfig, FileService fileService, BrowserUtils browserUtils) {
        this.runStepConfig = runStepConfig;
        this.jobConfig = jobConfig;
        this.fileService = fileService;
        this.browserUtils = browserUtils;
        this.threadPool = Utils.createThreadPool(jobConfig.threads, "BrowserThread");
        this.logErrorChecker = new LogErrorChecker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LOG.debug("Closing webdrivers.");
        this.shutdownCalled.getAndSet(true);
        ConcurrentHashMap<String, WebDriver> concurrentHashMap = this.webDrivers;
        synchronized (concurrentHashMap) {
            LOG.debug("Setting shutdown called to true");
            this.webDrivers.forEach((threadName, webDriver) -> {
                LOG.debug("Removing webdriver for thread {} ({})", threadName, (Object)webDriver.getClass().getCanonicalName());
                try {
                    webDriver.quit();
                }
                catch (Exception e) {
                    LOG.error("Exception while quitting webdriver: " + e.getMessage(), (Throwable)e);
                }
            });
            this.webDrivers.clear();
        }
        LOG.debug("Closing webdrivers done.");
        if (this.runStepConfig.isCleanupProfile()) {
            LOG.info("Cleaning up profile directory.");
            this.cleanupProfileDirectory();
            LOG.info("Profile cleanup done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSetupAndTakeScreenshots() throws Exception {
        List<ScreenshotContext> testSetupContexts = BrowserUtils.buildTestSetupContexts(this.runStepConfig, this.jobConfig);
        List<ScreenshotContext> testCleanupContexts = BrowserUtils.buildTestCleanupContexts(this.runStepConfig, this.jobConfig);
        List<ScreenshotContext> screenshotContextList = BrowserUtils.buildScreenshotContextListFromConfigAndState(this.runStepConfig, this.jobConfig);
        if (!screenshotContextList.isEmpty()) {
            try {
                if (!testSetupContexts.isEmpty()) {
                    LOG.debug("Running test setup.");
                    this.runTestSetupOrCleanup(testSetupContexts);
                    LOG.debug("Test setup done.");
                }
                try {
                    CloudBrowser cloudBrowser = CloudBrowserFactory.createCloudBrowser(this.runStepConfig, this.jobConfig, this.fileService);
                    LOG.info("Using cloud browser: {}", (Object)cloudBrowser.getClass().getCanonicalName());
                    this.cloudBrowserUsed = true;
                    cloudBrowser.takeScreenshots(screenshotContextList);
                }
                catch (ClassNotFoundException e) {
                    LOG.info(e.getMessage());
                    this.takeScreenshots(screenshotContextList);
                }
            }
            finally {
                if (!testCleanupContexts.isEmpty()) {
                    LOG.debug("Running test cleanup.");
                    this.runTestSetupOrCleanup(testCleanupContexts);
                    LOG.debug("Test cleanup done.");
                }
            }
        }
    }

    private void cleanupProfileDirectory() {
        if (!this.cloudBrowserUsed) {
            this.runStepConfig.getChromeParameters().forEach(param -> {
                if (param.startsWith("--user-data-dir")) {
                    try {
                        String path = param.split("=")[1];
                        if (path.endsWith("/{random-folder}")) {
                            path = path.substring(0, path.length() - "{random-folder}".length() - 1);
                        }
                        LOG.debug("Deleting chrome profile dir {}", (Object)path);
                        FileUtils.deleteDirectory(path);
                    }
                    catch (Exception e) {
                        LOG.error("Exception while deleting user data dir: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            });
            this.runStepConfig.getFirefoxParameters().forEach(param -> {
                if (param.startsWith("-profile") || param.startsWith("-P")) {
                    try {
                        String path = param.split(" ")[1];
                        if (path.endsWith("/{random-folder}")) {
                            path = path.substring(0, path.length() - "{random-folder}".length() - 1);
                        }
                        LOG.debug("Deleting firefox profile dir {}", (Object)path);
                        FileUtils.deleteDirectory(path);
                    }
                    catch (Exception e) {
                        LOG.error("Exception while deleting firefox profile dir: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            });
        }
    }

    private void runTestSetupOrCleanup(List<ScreenshotContext> testSetupOrCleanupContexts) throws Exception {
        JLineupHttpClient jLineupHttpClient = new JLineupHttpClient();
        for (ScreenshotContext testSetupContext : testSetupOrCleanupContexts) {
            jLineupHttpClient.callUrl(testSetupContext);
        }
    }

    void takeScreenshots(List<ScreenshotContext> screenshotContextList) throws Exception {
        boolean ranIntoTimeout;
        HashMap screenshotResults = new HashMap();
        for (ScreenshotContext screenshotContext : screenshotContextList) {
            if (this.runStepConfig.getStep() == RunStep.before && this.fileService.getFileTracker().isContextAlreadyThere(screenshotContext)) {
                if (screenshotContext.url.equals(this.runStepConfig.getRefreshUrl())) {
                    LOG.info("Re-shooting {} because of refresh argument.", (Object)screenshotContext.getShortDescription());
                    this.fileService.getFileTracker().removeContext(screenshotContext);
                } else {
                    LOG.info("Skipping {} because screenshots are already there.", (Object)screenshotContext.getShortDescription());
                    continue;
                }
            }
            Future<?> takeScreenshotsResult = this.threadPool.submit(() -> {
                MDC.put((String)"reportlogname", (String)(screenshotContext.fullPathOfReportDir + "/jlineup.log"));
                try {
                    this.tryToTakeScreenshotsForContextNTimes(screenshotContext, this.jobConfig.screenshotRetries);
                }
                catch (Exception e) {
                    LOG.error("Exception in Browser thread while working on '" + screenshotContext.url + "' with device config " + String.valueOf(screenshotContext.deviceConfig) + ".", (Throwable)e);
                    ConcurrentHashMap<String, WebDriver> concurrentHashMap = this.webDrivers;
                    synchronized (concurrentHashMap) {
                        this.threadPool.shutdownNow();
                    }
                    throw new WebDriverException("Exception in Browser thread", (Throwable)e);
                }
                finally {
                    MDC.remove((String)"reportlogname");
                }
            });
            screenshotResults.put(screenshotContext, takeScreenshotsResult);
            Thread.sleep(233L);
        }
        LOG.debug("All tasks have been sent to browser thread pool. Queuing shutdown.");
        this.threadPool.shutdown();
        LOG.debug("Browser thread pool shutdown queued. Doing work and awaiting termination. The global timeout is set to {} seconds.", (Object)this.jobConfig.globalTimeout);
        boolean bl = ranIntoTimeout = !this.threadPool.awaitTermination(this.jobConfig.globalTimeout, TimeUnit.SECONDS);
        if (ranIntoTimeout) {
            LOG.error("Browser thread pool ran into timeout.");
            throw new TimeoutException("Global timeout of " + this.jobConfig.globalTimeout + " seconds was reached. Set or increase global \"timeout\" variable in config to change default.");
        }
        LOG.debug("Browser thread pool terminated successfully.");
        for (Map.Entry screenshotResult : screenshotResults.entrySet()) {
            try {
                ((Future)screenshotResult.getValue()).get(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                LOG.error("Timeout while getting screenshot result for {} with device {}.", (Object)((ScreenshotContext)screenshotResult.getKey()).url, (Object)((ScreenshotContext)screenshotResult.getKey()).deviceConfig);
                throw e;
            }
        }
    }

    private void tryToTakeScreenshotsForContextNTimes(ScreenshotContext screenshotContext, int maxRetries) throws Exception {
        for (int retries = 0; retries <= maxRetries; ++retries) {
            try {
                this.takeScreenshotsForContext(screenshotContext);
                return;
            }
            catch (Exception e) {
                if (retries >= maxRetries) {
                    throw e;
                }
                LOG.warn("try '{}' to take screen failed", (Object)retries, (Object)e);
                continue;
            }
        }
    }

    private void takeScreenshotsForContext(ScreenshotContext screenshotContext) throws Exception {
        if (screenshotContext.urlConfig.httpCheck.isEnabled() || this.jobConfig.httpCheck.isEnabled()) {
            JLineupHttpClient jLineupHttpClient = new JLineupHttpClient();
            jLineupHttpClient.checkPageAccessibility(screenshotContext, this.jobConfig);
        }
        boolean headlessRealBrowserOrMobileEmulation = this.jobConfig.browser.isHeadlessRealBrowser() || screenshotContext.dontShareBrowser;
        WebDriver localDriver = headlessRealBrowserOrMobileEmulation ? this.initializeWebDriver(screenshotContext.deviceConfig) : this.initializeWebDriver();
        if (this.printVersion.getAndSet(false)) {
            LOG.info("User agent: " + this.getUserAgent());
            this.fileService.setBrowserAndVersion(screenshotContext, this.getBrowserAndVersion(localDriver));
        }
        if (!this.jobConfig.browser.isHeadless() && !ImageInfo.inImageCode()) {
            this.moveMouseToZeroZero();
        }
        if (!headlessRealBrowserOrMobileEmulation) {
            localDriver.manage().window().setPosition(new Point(0, 0));
            this.resizeBrowser(localDriver, screenshotContext.deviceConfig.width, screenshotContext.deviceConfig.height);
        }
        if ((this.jobConfig.browser.isChrome() || this.jobConfig.browser.isChromium()) && this.jobConfig.browser.isHeadless() && !screenshotContext.deviceConfig.isMobile()) {
            this.resizeViewport(localDriver, screenshotContext.deviceConfig.width, screenshotContext.deviceConfig.height);
            this.resizeViewport(localDriver, screenshotContext.deviceConfig.width, screenshotContext.deviceConfig.height);
        }
        String url = BrowserUtils.buildUrl(screenshotContext.url, screenshotContext.urlSubPath, screenshotContext.urlConfig.envMapping);
        String rootUrl = BrowserUtils.buildUrl(screenshotContext.url, "", screenshotContext.urlConfig.envMapping);
        if (this.areThereCookies(screenshotContext)) {
            this.setCookies(screenshotContext, localDriver);
        }
        if (this.isThereStorage(screenshotContext)) {
            if (!localDriver.getCurrentUrl().equals(rootUrl)) {
                LOG.info(String.format("Getting root url: %s to set local and session storage", rootUrl));
                localDriver.get(rootUrl);
                this.logErrorChecker.checkForErrors(localDriver, this.jobConfig);
            }
            this.setLocalStorage(screenshotContext);
            this.setSessionStorage(screenshotContext);
        }
        this.browserCacheWarmup(screenshotContext, url, localDriver);
        if (!screenshotContext.deviceConfig.isSpecificMobile()) {
            LOG.info("Browsing to {} with device {} and window size {}x{}", new Object[]{url, screenshotContext.deviceConfig.deviceName, screenshotContext.deviceConfig.width, screenshotContext.deviceConfig.height});
        } else {
            LOG.info("Browsing to {} with device {}", (Object)url, (Object)screenshotContext.deviceConfig.deviceName);
        }
        localDriver.get(url);
        this.waitForSelectors(screenshotContext.urlConfig.waitForSelectors, screenshotContext.urlConfig.waitForSelectorsTimeout, screenshotContext.urlConfig.failIfSelectorsNotFound);
        this.logErrorChecker.checkForErrors(localDriver, this.jobConfig);
        if (screenshotContext.urlConfig.waitAfterPageLoad > 0.0f) {
            try {
                LOG.debug(String.format("Waiting for %f seconds (wait-after-page-load)", Float.valueOf(screenshotContext.urlConfig.waitAfterPageLoad)));
                Thread.sleep(Math.round(screenshotContext.urlConfig.waitAfterPageLoad * 1000.0f));
            }
            catch (InterruptedException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.jobConfig.globalWaitAfterPageLoad.floatValue() > 0.0f) {
            LOG.debug(String.format("Waiting for %f seconds (global wait-after-page-load)", this.jobConfig.globalWaitAfterPageLoad));
            Thread.sleep(Math.round(this.jobConfig.globalWaitAfterPageLoad.floatValue() * 1000.0f));
        }
        this.executeJavaScript(screenshotContext.urlConfig.javaScript);
        if (screenshotContext.urlConfig.hideImages) {
            this.executeJavaScript(JS_HIDE_IMAGES_CALL);
        }
        this.removeNodes(screenshotContext);
        if (screenshotContext.urlConfig.waitForFontsTime > 0.0f) {
            WebDriverWait wait = new WebDriverWait(this.getWebDriver(), Duration.ofSeconds(Math.round(Math.ceil(screenshotContext.urlConfig.waitForFontsTime))));
            wait.until(this.fontsLoaded);
        }
        Long pageHeight = this.getPageHeight();
        int viewportHeight = Math.toIntExact(this.getViewportHeight());
        LOG.debug("Page height before scrolling: {}", (Object)pageHeight);
        this.scrollToTop();
        viewportHeight = this.validateViewportHeight(viewportHeight);
        LOG.debug("Viewport height of browser window: {}", (Object)viewportHeight);
        for (int yPosition = 0; (long)yPosition < pageHeight && yPosition <= screenshotContext.urlConfig.maxScrollHeight; yPosition += viewportHeight) {
            LOG.debug("Scrolling info: yPosition: {}, pageHeight: {}, maxScrollHeight: {}, viewPortHeight: {}", new Object[]{yPosition, pageHeight, screenshotContext.urlConfig.maxScrollHeight, viewportHeight});
            BufferedImage currentScreenshot = this.takeScreenshot();
            currentScreenshot = this.waitForNoAnimation(screenshotContext, currentScreenshot);
            if ((long)(yPosition + viewportHeight) > pageHeight && GlobalOptions.getOption(GlobalOption.JLINEUP_CROP_LAST_SCREENSHOT).equalsIgnoreCase("true")) {
                LOG.debug("Last screenshot. Will crop image. Page height: {}, yPosition: {}, viewportHeight: {}", new Object[]{pageHeight, yPosition, viewportHeight});
                BufferedImage croppedAndFilledScreenshot = new BufferedImage(currentScreenshot.getWidth(), currentScreenshot.getHeight(), 6);
                Graphics2D g = croppedAndFilledScreenshot.createGraphics();
                g.setColor(this.getBodyColor());
                g.fillRect(0, 0, currentScreenshot.getWidth(), currentScreenshot.getHeight());
                g.drawImage((Image)currentScreenshot, 0, -((int)((double)((long)(yPosition + viewportHeight) - pageHeight) * this.getDevicePixelRatio())), null);
                currentScreenshot = croppedAndFilledScreenshot;
            }
            this.fileService.writeScreenshot(screenshotContext, currentScreenshot, yPosition);
            LOG.debug("topOfViewport: {}, pageHeight: {}", (Object)yPosition, (Object)pageHeight);
            this.scrollTo(yPosition + viewportHeight);
            LOG.debug("Scroll by {} done", (Object)viewportHeight);
            if (screenshotContext.urlConfig.waitAfterScroll > 0.0f) {
                LOG.debug("Waiting for {} seconds (wait after scroll).", (Object)Float.valueOf(screenshotContext.urlConfig.waitAfterScroll));
                TimeUnit.MILLISECONDS.sleep(Math.round(screenshotContext.urlConfig.waitAfterScroll * 1000.0f));
            }
            pageHeight = this.getPageHeight();
            LOG.debug("Page height is {}", (Object)pageHeight);
        }
        if (LOG.isDebugEnabled()) {
            try {
                LogEntries logEntries = localDriver.manage().logs().get("browser");
                for (LogEntry logEntry : logEntries) {
                    LOG.debug("Browser console: {}", (Object)logEntry.toString());
                }
            }
            catch (Exception e) {
                LOG.debug("No browser console available.");
            }
        }
        this.fileService.writeFileTrackerData();
        this.fileService.writeFileTrackerDataForScreenshotContextOnly(screenshotContext);
    }

    private int validateViewportHeight(int viewportHeight) throws IOException {
        BufferedImage bufferedImage = this.takeScreenshot();
        int realHeight = Math.toIntExact(Math.round(1.0 * (double)bufferedImage.getHeight() / this.getDevicePixelRatio()));
        if (viewportHeight != realHeight) {
            LOG.warn("Calculated viewport height '{}' differs from screenshot height '{}'! Using screenshot height to proceed.", (Object)viewportHeight, (Object)realHeight);
        }
        return realHeight;
    }

    private String getBrowserAndVersion(WebDriver driver) {
        Capabilities capabilities = ((HasCapabilities)driver).getCapabilities();
        Object browserName = capabilities.getBrowserName();
        browserName = ((String)browserName).substring(0, 1).toUpperCase() + ((String)browserName).substring(1);
        String browserVersion = capabilities.getBrowserVersion();
        return (String)browserName + " " + browserVersion;
    }

    private void resizeBrowser(WebDriver driver, int width, int height) {
        LOG.debug("Resize browser window to {}x{}", (Object)width, (Object)height);
        driver.manage().window().setSize(new Dimension(width, height));
    }

    private void resizeViewport(WebDriver driver, int width, int height) {
        LOG.debug("Resize viewport of browser window to {}x{}", (Object)width, (Object)height);
        JavascriptExecutor js = (JavascriptExecutor)driver;
        String windowSize = js.executeScript("return (window.outerWidth - window.innerWidth + " + width + ") + ',' + (window.outerHeight - window.innerHeight + " + height + "); ", new Object[0]).toString();
        int calculatedWindowWidth = Integer.parseInt(windowSize.split(",")[0]);
        int calculatedWindowHeight = Integer.parseInt(windowSize.split(",")[1]);
        if (calculatedWindowWidth > 0 && calculatedWindowHeight > 0) {
            driver.manage().window().setSize(new Dimension(calculatedWindowWidth, calculatedWindowHeight));
        }
    }

    private boolean areThereCookies(ScreenshotContext screenshotContext) {
        return screenshotContext.cookies != null && !screenshotContext.cookies.isEmpty();
    }

    private boolean isThereStorage(ScreenshotContext screenshotContext) {
        return screenshotContext.urlConfig.localStorage != null && screenshotContext.urlConfig.localStorage.size() > 0 || screenshotContext.urlConfig.sessionStorage != null && screenshotContext.urlConfig.sessionStorage.size() > 0;
    }

    private void setCookies(ScreenshotContext screenshotContext, WebDriver localDriver) {
        Map<String, List<de.otto.jlineup.config.Cookie>> cookiesByDomainDifferentFromDomainToScreenshot = screenshotContext.cookies.stream().filter(cookie -> cookie.domain != null).collect(Collectors.groupingBy(cookie -> cookie.domain));
        cookiesByDomainDifferentFromDomainToScreenshot.forEach((domain, cookies) -> this.setCookiesForDomain(localDriver, (String)domain, (List<de.otto.jlineup.config.Cookie>)cookies));
        List<de.otto.jlineup.config.Cookie> cookiesForSameDomain = screenshotContext.cookies.stream().filter(cookie -> cookie.domain == null).collect(Collectors.toList());
        this.setCookiesForDomain(localDriver, screenshotContext.url, cookiesForSameDomain);
    }

    private void setCookiesForDomain(WebDriver driver, String domain, List<de.otto.jlineup.config.Cookie> cookies) {
        if (cookies == null || cookies.isEmpty()) {
            LOG.debug("There are no cookies for domain {}", (Object)domain);
            return;
        }
        boolean secure = cookies.stream().anyMatch(cookie -> cookie.secure);
        Object urlToSetCookie = domain;
        if (!((String)urlToSetCookie).startsWith("http")) {
            if (((String)urlToSetCookie).startsWith(".")) {
                urlToSetCookie = ((String)urlToSetCookie).substring(1);
            }
            urlToSetCookie = (secure ? "https://" : "http://") + (String)urlToSetCookie;
        }
        LOG.debug("Going to {} to set cookies afterwards.", urlToSetCookie);
        driver.get((String)urlToSetCookie);
        LOG.debug("Opened {}.", urlToSetCookie);
        this.logErrorChecker.checkForErrors(driver, this.jobConfig);
        LOG.debug("Setting cookies on {}", urlToSetCookie);
        this.setCookies(cookies);
        LOG.debug("Finished setting cookies on {}", urlToSetCookie);
    }

    private void browserCacheWarmup(ScreenshotContext screenshotContext, String url, WebDriver driver) throws Exception {
        float warmupTime = screenshotContext.urlConfig.warmupBrowserCacheTime;
        if (warmupTime > 0.0f) {
            LOG.info(String.format("Browsing to %s with device config %s for cache warmup", url, screenshotContext.deviceConfig.toString()));
            LOG.debug("Getting url: {}", (Object)url);
            driver.get(url);
            this.logErrorChecker.checkForErrors(driver, this.jobConfig);
            LOG.debug(String.format("First call of %s - waiting %f seconds for cache warmup", url, Float.valueOf(warmupTime)));
            LOG.debug("Sleeping for {} seconds", (Object)Float.valueOf(warmupTime));
            Thread.sleep(Math.round(warmupTime * 1000.0f));
            LOG.debug("Cache warmup time is over. Getting " + url + " again.");
        }
    }

    private BufferedImage takeScreenshot() throws IOException {
        LOG.debug("Taking screenshot.");
        File screenshot = (File)((TakesScreenshot)this.getWebDriver()).getScreenshotAs(OutputType.FILE);
        return ImageIO.read(screenshot);
    }

    private BufferedImage waitForNoAnimation(ScreenshotContext screenshotContext, BufferedImage currentScreenshot) throws IOException {
        float waitForNoAnimation = screenshotContext.urlConfig.waitForNoAnimationAfterScroll;
        if (waitForNoAnimation > 0.0f) {
            LOG.debug("Waiting for no animation.");
            long beginTime = System.currentTimeMillis();
            int sameCounter = 0;
            while (sameCounter < 10 && !this.timeIsOver(beginTime, waitForNoAnimation)) {
                File screenshot = (File)((TakesScreenshot)this.getWebDriver()).getScreenshotAs(OutputType.FILE);
                BufferedImage newScreenshot = ImageIO.read(screenshot);
                if (ImageService.bufferedImagesEqualQuick(newScreenshot, currentScreenshot)) {
                    ++sameCounter;
                }
                currentScreenshot = newScreenshot;
            }
        }
        return currentScreenshot;
    }

    private boolean timeIsOver(long beginTime, float waitForNoAnimation) {
        boolean over;
        boolean bl = over = beginTime + (long)(waitForNoAnimation * 1000.0f) < System.currentTimeMillis();
        if (over) {
            LOG.debug("Time is over");
        }
        return over;
    }

    private Long getPageHeight() {
        LOG.debug("Getting page height.");
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        return (Long)jse.executeScript(JS_DOCUMENT_HEIGHT_CALL, new Object[0]);
    }

    private Long getViewportHeight() {
        LOG.debug("Getting viewport height.");
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        return (Long)jse.executeScript(JS_CLIENT_VIEWPORT_HEIGHT_CALL, new Object[0]);
    }

    private Double getDevicePixelRatio() {
        LOG.debug("Getting device pixel ratio.");
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        return ((Number)jse.executeScript(JS_GET_DEVICE_PIXEL_RATIO_CALL, new Object[0])).doubleValue();
    }

    private String getDom() {
        LOG.debug("Getting DOM.");
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        return (String)jse.executeScript(JS_GET_DOM_CALL, new Object[0]);
    }

    private void executeJavaScript(String javaScript) throws InterruptedException {
        if (javaScript == null || "".equals(javaScript)) {
            return;
        }
        if (javaScript.contains(JLINEUP_SLEEP_JS_OPENER)) {
            this.executeJavaScriptWithJlineupAdditions(javaScript);
            return;
        }
        LOG.debug("Executing JavaScript: {}", (Object)javaScript);
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        jse.executeScript(javaScript, new Object[0]);
        Thread.sleep(50L);
    }

    private void executeJavaScriptWithJlineupAdditions(String javaScript) throws InterruptedException {
        LOG.debug("Executing JavaScript with JLineup additions: {}", (Object)javaScript);
        String[] parts = javaScript.split("jlineup.sleep\\(");
        this.executeJavaScript(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            String secondsFollowedByClosingBracketAndMaybeASemicolonAndMoreJavaScript = parts[i];
            String[] secondsAndRemainingJS = secondsFollowedByClosingBracketAndMaybeASemicolonAndMoreJavaScript.split("\\)", 2);
            int milliseconds = Integer.parseInt(secondsAndRemainingJS[0].replace(";", ""));
            LOG.debug("Sleeping for {} milliseconds", (Object)milliseconds);
            this.executeJavaScript("/* sleeping " + milliseconds + " milliseconds */");
            Thread.sleep(milliseconds);
            if (secondsAndRemainingJS.length <= 1) continue;
            String js = secondsAndRemainingJS[1];
            this.executeJavaScript(js);
        }
    }

    private String getUserAgent() {
        LOG.debug("Getting browser user agent.");
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        return (String)jse.executeScript(JS_GET_USER_AGENT_CALL, new Object[0]);
    }

    private Color getBodyColor() {
        LOG.debug("Getting body color.");
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        List bodyColor = (List)jse.executeScript(JS_GET_BODY_COLOR_CALL, new Object[0]);
        return new Color(Integer.parseInt((String)bodyColor.get(0)), Integer.parseInt((String)bodyColor.get(1)), Integer.parseInt((String)bodyColor.get(2)));
    }

    void scrollTo(int yPosition) throws InterruptedException {
        LOG.debug("Scroll to {}", (Object)yPosition);
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        jse.executeScript(String.format(JS_SCROLL_TO_CALL, yPosition), new Object[0]);
        Thread.sleep(50L);
    }

    private void scrollToTop() throws InterruptedException {
        LOG.debug("Scroll to top");
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        jse.executeScript(JS_SCROLL_TO_TOP_CALL, new Object[0]);
        Thread.sleep(50L);
    }

    private void setLocalStorage(ScreenshotContext screenshotContext) {
        this.setLocalStorage(screenshotContext.urlConfig.localStorage);
    }

    private void setSessionStorage(ScreenshotContext screenshotContext) {
        this.setSessionStorage(screenshotContext.urlConfig.sessionStorage);
    }

    private void removeNodes(ScreenshotContext screenshotContext) {
        this.removeNodes(screenshotContext.urlConfig.removeSelectors);
    }

    void setLocalStorage(Map<String, String> localStorage) {
        if (localStorage == null) {
            return;
        }
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        for (Map.Entry<String, String> localStorageEntry : localStorage.entrySet()) {
            String entry = localStorageEntry.getValue() != null ? localStorageEntry.getValue().replace("'", "\"") : null;
            String jsCall = String.format(JS_SET_LOCAL_STORAGE_CALL, localStorageEntry.getKey(), entry);
            jse.executeScript(jsCall, new Object[0]);
            LOG.debug("LocalStorage call: {}", (Object)jsCall.replace(entry, "*****"));
        }
    }

    void removeNodes(Set<String> cssSelectors) {
        if (cssSelectors == null || cssSelectors.isEmpty()) {
            return;
        }
        LOG.debug("Removing nodes with CSS selectors.");
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        for (String cssSelector : cssSelectors) {
            String jsCall = String.format(JS_REMOVE_FROM_DOM_CALL, cssSelector);
            jse.executeScript(jsCall, new Object[0]);
            LOG.debug("Remove from DOM call: {}", (Object)jsCall);
        }
    }

    void waitForSelectors(Set<String> cssSelectors, float timeout, boolean failIfNotFound) throws InterruptedException {
        if (cssSelectors == null || cssSelectors.isEmpty()) {
            return;
        }
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        int retries = Double.valueOf(Math.ceil(timeout)).intValue();
        for (String cssSelector : cssSelectors) {
            boolean found = false;
            String jsCall = String.format(JS_CHECK_FOR_ELEMENT_CALL, cssSelector);
            while (!found && retries > 0) {
                found = (Boolean)jse.executeScript(jsCall, new Object[0]);
                LOG.debug("Wait for CSS selector call: {}, retries left: {}", (Object)jsCall, (Object)retries);
                Thread.sleep(1000L);
                --retries;
            }
            LOG.info("{} '{}' with {} retries left.", new Object[]{found ? "Found" : "Didn't find", cssSelector, retries});
            if (found || !failIfNotFound) continue;
            throw new RuntimeException("Didn't find element with selector '" + cssSelector + "'.");
        }
    }

    void setSessionStorage(Map<String, String> sessionStorage) {
        if (sessionStorage == null) {
            return;
        }
        JavascriptExecutor jse = (JavascriptExecutor)this.getWebDriver();
        for (Map.Entry<String, String> sessionStorageEntry : sessionStorage.entrySet()) {
            String entry = sessionStorageEntry.getValue().replace("'", "\"");
            String jsCall = String.format(JS_SET_SESSION_STORAGE_CALL, sessionStorageEntry.getKey(), entry);
            jse.executeScript(jsCall, new Object[0]);
            LOG.debug("SessionStorage call: {}", (Object)jsCall.replace(entry, "*****"));
        }
    }

    void setCookies(List<de.otto.jlineup.config.Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        for (de.otto.jlineup.config.Cookie cookie : cookies) {
            Cookie.Builder cookieBuilder = new Cookie.Builder(cookie.name, cookie.value);
            if (cookie.domain != null) {
                cookieBuilder.domain(cookie.domain);
            }
            if (cookie.path != null) {
                cookieBuilder.path(cookie.path);
            }
            if (cookie.expiry != null) {
                cookieBuilder.expiresOn(cookie.expiry);
            }
            cookieBuilder.isSecure(cookie.secure);
            Cookie seleniumCookie = cookieBuilder.build();
            LOG.debug("Setting cookie through webdriver : {}", (Object)seleniumCookie.toString().replace(cookie.value, "*****"));
            this.getWebDriver().manage().addCookie(seleniumCookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebDriver initializeWebDriver(DeviceConfig device) {
        if (this.shutdownCalled.get()) {
            return null;
        }
        ConcurrentHashMap<String, WebDriver> concurrentHashMap = this.webDrivers;
        synchronized (concurrentHashMap) {
            String currentThreadName = Thread.currentThread().getName();
            if (this.webDrivers.containsKey(currentThreadName)) {
                WebDriver oldDriver = this.webDrivers.get(currentThreadName);
                LOG.debug("Removing webdriver for thread {} ({})", (Object)currentThreadName, (Object)oldDriver.getClass().getCanonicalName());
                try {
                    oldDriver.close();
                }
                catch (Exception e) {
                    LOG.debug("Exception while closing webdriver: " + e.getMessage(), (Throwable)e);
                }
                try {
                    oldDriver.quit();
                }
                catch (Exception e) {
                    LOG.debug("Exception while quitting webdriver: " + e.getMessage(), (Throwable)e);
                }
            }
            WebDriver driver = this.createDriverWithEmulatedDevice(device);
            this.webDrivers.put(currentThreadName, driver);
            return driver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebDriver initializeWebDriver() {
        if (this.shutdownCalled.get()) {
            return null;
        }
        ConcurrentHashMap<String, WebDriver> concurrentHashMap = this.webDrivers;
        synchronized (concurrentHashMap) {
            WebDriver driver;
            if (this.shutdownCalled.get()) {
                return null;
            }
            String currentThreadName = Thread.currentThread().getName();
            if (this.webDrivers.containsKey(currentThreadName)) {
                driver = this.webDrivers.get(currentThreadName);
            } else {
                driver = this.createDriver();
                this.webDrivers.put(currentThreadName, driver);
            }
            return driver;
        }
    }

    private WebDriver createDriver() {
        this.shutdownCalled.get();
        WebDriver driver = this.browserUtils.getWebDriverByConfig(this.jobConfig, this.runStepConfig);
        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(60L));
        LOG.debug("Adding webdriver for thread {} ({})", (Object)Thread.currentThread().getName(), (Object)driver.getClass().getCanonicalName());
        return driver;
    }

    private WebDriver createDriverWithEmulatedDevice(DeviceConfig device) {
        WebDriver driver = this.browserUtils.getWebDriverByConfig(this.jobConfig, this.runStepConfig, device);
        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(60L));
        LOG.debug("Adding webdriver for thread {} with emulated device {} ({})", new Object[]{Thread.currentThread().getName(), device, driver.getClass().getCanonicalName()});
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebDriver getWebDriver() {
        ConcurrentHashMap<String, WebDriver> concurrentHashMap = this.webDrivers;
        synchronized (concurrentHashMap) {
            return this.webDrivers.get(Thread.currentThread().getName());
        }
    }

    private void moveMouseToZeroZero() {
        try {
            Robot robot = new Robot();
            robot.mouseMove(0, 0);
        }
        catch (AWTException e) {
            LOG.error("Can't move mouse to 0,0", (Throwable)e);
        }
    }

    public void runForScreenshotContext(ScreenshotContext screenshotContext) throws Exception {
        this.takeScreenshotsForContext(screenshotContext);
    }

    void grepChromedrivers() throws IOException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        Process process = pb.command("/bin/sh", "-c", "ps -eaf | grep chromedriver").start();
        new BufferedReader(new InputStreamReader(process.getInputStream())).lines().forEach(System.err::println);
    }

    public static enum Type {
        FIREFOX,
        FIREFOX_HEADLESS,
        CHROME,
        CHROME_HEADLESS,
        CHROMIUM,
        CHROMIUM_HEADLESS,
        SAFARI;


        public boolean isFirefox() {
            return this == FIREFOX || this == FIREFOX_HEADLESS;
        }

        public boolean isChrome() {
            return this == CHROME || this == CHROME_HEADLESS;
        }

        public boolean isChromium() {
            return this == CHROMIUM || this == CHROMIUM_HEADLESS;
        }

        public boolean isSafari() {
            return this == SAFARI;
        }

        public boolean isHeadlessRealBrowser() {
            return this == FIREFOX_HEADLESS || this == CHROME_HEADLESS || this == CHROMIUM_HEADLESS;
        }

        public boolean isHeadless() {
            return this.isHeadlessRealBrowser();
        }

        @JsonCreator
        public static Type forValue(String value) {
            String browserNameEnum = value.toUpperCase().replace("-", "_");
            return Type.valueOf(browserNameEnum);
        }
    }
}

