/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import de.otto.jlineup.GlobalOption;
import de.otto.jlineup.GlobalOptions;
import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.Cookie;
import de.otto.jlineup.config.DeviceConfig;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.UrlConfig;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.safari.SafariDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean CHROME_DETERMINISTIC_OPTIONS = true;
    public static final String RANDOM_FOLDER_PLACEHOLDER = "{random-folder}";

    public static String buildUrl(String url, String path, Map<String, String> envMapping) {
        if (envMapping != null && !envMapping.isEmpty()) {
            for (Map.Entry<String, String> envMappingEntry : envMapping.entrySet()) {
                String fromEnvironment = envMappingEntry.getKey();
                String toEnvironment = envMappingEntry.getValue();
                url = url.replace("https://" + fromEnvironment + ".", "https://" + toEnvironment + ".");
                url = url.replace("http://" + fromEnvironment + ".", "http://" + toEnvironment + ".");
                url = url.replace("." + fromEnvironment + ".", "." + toEnvironment + ".");
            }
        }
        return BrowserUtils.buildUrl(url, path);
    }

    static String buildUrl(String url, String path) {
        if (path == null) {
            path = "";
        }
        if (!(((String)url).endsWith("/") || path.equals("") || path.startsWith("/"))) {
            url = (String)url + "/";
        }
        if (((String)url).endsWith("/") && path.startsWith("/")) {
            path = path.substring(1);
        }
        return (String)url + path;
    }

    synchronized WebDriver getWebDriverByConfig(JobConfig jobConfig, RunStepConfig runStepConfig) {
        return this.getWebDriverByConfig(jobConfig, runStepConfig, new DeviceConfig());
    }

    synchronized WebDriver getWebDriverByConfig(JobConfig jobConfig, RunStepConfig runStepConfig, DeviceConfig device) {
        ChromeDriver driver;
        if (jobConfig.browser.isFirefox()) {
            String firefoxVersionOverride;
            FirefoxOptions options = new FirefoxOptions();
            FirefoxProfile firefoxProfileWithDisabledAnimatedGifs = this.getFirefoxProfileWithDisabledAnimatedGifs();
            options.setProfile(firefoxProfileWithDisabledAnimatedGifs);
            options.addArguments(runStepConfig.getFirefoxParameters());
            if (jobConfig.browser.isHeadless()) {
                options.addArguments(new String[]{"-headless", "-width", "" + device.width, "-height", "" + device.height});
            }
            if ((firefoxVersionOverride = GlobalOptions.getOption(GlobalOption.JLINEUP_FIREFOX_VERSION)) != null) {
                options.setBrowserVersion(firefoxVersionOverride);
            }
            LOG.debug("Creating firefox with options: {}", (Object)options.toString());
            driver = new FirefoxDriver(options);
        } else if (jobConfig.browser.isChrome()) {
            String chromeVersionOverride;
            ChromeOptions options = new ChromeOptions();
            options.addArguments(new String[]{"--no-sandbox"});
            options.addArguments(new String[]{"--whitelisted-ips"});
            options.addArguments(new String[]{"--remote-allow-origins=*"});
            options.addArguments(new String[]{"--disable-search-engine-choice-screen"});
            options.addArguments(runStepConfig.getChromeParameters().stream().map(param -> param.replace(RANDOM_FOLDER_PLACEHOLDER, UUID.randomUUID().toString())).collect(Collectors.toList()));
            options.addArguments(new String[]{"--deterministic-mode"});
            options.addArguments(new String[]{"--disable-checker-imaging"});
            options.addArguments(new String[]{"--disable-composited-antialiasing"});
            options.addArguments(new String[]{"--disable-gpu"});
            options.addArguments(new String[]{"--disable-gpu-rasterization"});
            options.addArguments(new String[]{"--disable-histogram-customizer"});
            options.addArguments(new String[]{"--disable-partial-raster"});
            options.addArguments(new String[]{"--disable-skia-runtime-opts"});
            options.addArguments(new String[]{"--disable-smooth-scrolling"});
            options.addArguments(new String[]{"--disable-threaded-animation"});
            options.addArguments(new String[]{"--disable-threaded-scrolling"});
            options.addArguments(new String[]{"--enable-surface-synchronization"});
            options.addArguments(new String[]{"--force-color-profile=srgb"});
            options.addArguments(new String[]{"--num-raster-threads=1"});
            options.addArguments(new String[]{"--run-all-compositor-stages-before-draw"});
            options.addArguments(new String[]{"--override-use-software-gl-for-tests"});
            if (device.isMobile()) {
                Map<String, Object> mobileEmulation = BrowserUtils.getMobileEmulationPropertiesForChrome(device);
                options.setExperimentalOption("mobileEmulation", mobileEmulation);
            } else if (device.userAgent != null) {
                options.addArguments(new String[]{"--user-agent='" + device.userAgent + "'"});
            }
            if (jobConfig.browser.isHeadless()) {
                options.addArguments(new String[]{"--headless=new"});
                options.addArguments(new String[]{"--window-size=" + device.width + "," + device.height});
            }
            if ((chromeVersionOverride = GlobalOptions.getOption(GlobalOption.JLINEUP_CHROME_VERSION)) != null) {
                options.setBrowserVersion(chromeVersionOverride);
            }
            LOG.debug("Creating chrome with options: {}", (Object)options);
            driver = new ChromeDriver(options);
        } else if (jobConfig.browser.isChromium()) {
            driver = new ChromeDriver();
        } else if (jobConfig.browser.isSafari()) {
            driver = new SafariDriver();
        } else {
            LOG.error("You need either Firefox or Chrome / Chromium to make JLineup work. Install one of them and try again.");
            throw new RuntimeException("You need either Firefox or Chrome / Chromium to make JLineup work. Install one of them and try again.");
        }
        if (driver.manage() == null) {
            LOG.error("Browser could not be started or it crashed. :( Something went wrong.");
            throw new RuntimeException("Browser could not be started or it crashed. :(");
        }
        driver.manage().timeouts().pageLoadTimeout(Duration.of(jobConfig.pageLoadTimeout, ChronoUnit.SECONDS));
        return driver;
    }

    private static Map<String, Object> getMobileEmulationPropertiesForChrome(DeviceConfig device) {
        HashMap<String, Object> mobileEmulation = new HashMap<String, Object>();
        if (!device.deviceName.equalsIgnoreCase("MOBILE")) {
            mobileEmulation.put("deviceName", device.deviceName);
        } else {
            HashMap<String, Serializable> deviceMetrics = new HashMap<String, Serializable>();
            deviceMetrics.put("width", Integer.valueOf(device.width));
            deviceMetrics.put("height", Integer.valueOf(device.height));
            deviceMetrics.put("pixelRatio", Float.valueOf(device.pixelRatio));
            deviceMetrics.put("touch", Boolean.valueOf(true));
            mobileEmulation.put("deviceMetrics", deviceMetrics);
            if (device.userAgent != null) {
                mobileEmulation.put("userAgent", device.userAgent);
            }
        }
        return mobileEmulation;
    }

    private FirefoxProfile getFirefoxProfileWithDisabledAnimatedGifs() {
        FirefoxProfile firefoxProfileHeadless = new FirefoxProfile();
        firefoxProfileHeadless.setPreference("image.animation_mode", (Object)"none");
        return firefoxProfileHeadless;
    }

    public static List<ScreenshotContext> buildScreenshotContextListFromConfigAndState(RunStepConfig runStepConfig, JobConfig jobConfig) {
        ArrayList<ScreenshotContext> screenshotContextList = new ArrayList<ScreenshotContext>();
        Map<Object, Object> urls = jobConfig.urls == null ? Collections.emptyMap() : jobConfig.urls;
        for (Map.Entry<Object, Object> urlConfigEntry : urls.entrySet()) {
            UrlConfig urlConfig = (UrlConfig)urlConfigEntry.getValue();
            AtomicBoolean dontShareBrowser = new AtomicBoolean(false);
            urlConfig.devices.forEach(config -> {
                if (config.isMobile()) {
                    dontShareBrowser.set(true);
                }
            });
            for (String path : urlConfig.paths) {
                if (urlConfig.alternatingCookies.isEmpty()) {
                    screenshotContextList.addAll(urlConfig.devices.stream().map(deviceConfig -> new ScreenshotContext(BrowserUtils.prepareDomain(runStepConfig, urlConfig.url), path, (DeviceConfig)deviceConfig, urlConfig.cookies, runStepConfig.getBrowserStep(), urlConfig, BrowserUtils.getFullPathOfReportDir(runStepConfig), dontShareBrowser.get(), (String)urlConfigEntry.getKey())).toList());
                    continue;
                }
                screenshotContextList.addAll(urlConfig.devices.stream().flatMap(deviceConfig -> urlConfig.alternatingCookies.stream().map(alternatingCookies -> {
                    ArrayList<Cookie> newCookies = urlConfig.cookies != null ? new ArrayList<Cookie>(urlConfig.cookies) : new ArrayList();
                    newCookies.addAll((Collection<Cookie>)alternatingCookies);
                    return new ScreenshotContext(BrowserUtils.prepareDomain(runStepConfig, ((UrlConfig)urlConfigEntry.getValue()).url), path, (DeviceConfig)deviceConfig, (List<Cookie>)newCookies, runStepConfig.getBrowserStep(), urlConfig, BrowserUtils.getFullPathOfReportDir(runStepConfig), dontShareBrowser.get(), (String)urlConfigEntry.getKey());
                })).toList());
            }
        }
        return screenshotContextList;
    }

    public static List<ScreenshotContext> buildTestSetupContexts(RunStepConfig runStepConfig, JobConfig jobConfig) {
        return BrowserUtils.buildTestContexts(runStepConfig, jobConfig, true);
    }

    public static List<ScreenshotContext> buildTestCleanupContexts(RunStepConfig runStepConfig, JobConfig jobConfig) {
        return BrowserUtils.buildTestContexts(runStepConfig, jobConfig, false);
    }

    private static List<ScreenshotContext> buildTestContexts(RunStepConfig runStepConfig, JobConfig jobConfig, boolean setupPhase) {
        ArrayList<ScreenshotContext> screenshotContextList = new ArrayList<ScreenshotContext>();
        Map<Object, Object> urls = jobConfig.urls == null ? Collections.emptyMap() : jobConfig.urls;
        for (Map.Entry<Object, Object> urlConfigEntry : urls.entrySet()) {
            List<String> paths = setupPhase ? ((UrlConfig)urlConfigEntry.getValue()).setupPaths : ((UrlConfig)urlConfigEntry.getValue()).cleanupPaths;
            for (String path : paths) {
                screenshotContextList.add(new ScreenshotContext(BrowserUtils.prepareDomain(runStepConfig, ((UrlConfig)urlConfigEntry.getValue()).url), path, DeviceConfig.deviceConfigBuilder().build(), ((UrlConfig)urlConfigEntry.getValue()).cookies, runStepConfig.getBrowserStep(), (UrlConfig)urlConfigEntry.getValue(), BrowserUtils.getFullPathOfReportDir(runStepConfig), false, (String)urlConfigEntry.getKey()));
            }
        }
        return screenshotContextList;
    }

    public static String getFullPathOfReportDir(RunStepConfig runStepConfig) {
        if (runStepConfig.getReportDirectory() == null) {
            return null;
        }
        return Paths.get(runStepConfig.getWorkingDirectory(), runStepConfig.getReportDirectory()).toAbsolutePath().toString();
    }

    public static String getFullPathToLogFile(RunStepConfig runStepConfig) {
        if (runStepConfig.getReportDirectory() == null) {
            return null;
        }
        return Paths.get(Objects.requireNonNull(BrowserUtils.getFullPathOfReportDir(runStepConfig)), "jlineup.log").toAbsolutePath().toString();
    }

    public static String prepareDomain(RunStepConfig runStepConfig, String url) {
        String processedUrl = url;
        for (Map.Entry<String, String> replacement : runStepConfig.getUrlReplacements().entrySet()) {
            processedUrl = processedUrl.replace(replacement.getKey(), replacement.getValue());
        }
        return processedUrl;
    }

    public static String prependHTTPIfNotThereAndToLowerCase(String url) {
        Object ret = url.toLowerCase();
        if (!(url.startsWith("http://") || url.startsWith("https://") || url.startsWith("file://") || url.startsWith("ftp://"))) {
            ret = "http://" + (String)ret;
        }
        return ret;
    }
}

