/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.browser.CloudBrowser;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.file.FileService;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudBrowserFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static CloudBrowser createCloudBrowser(RunStepConfig runStepConfig, JobConfig jobConfig, FileService fileService) throws ClassNotFoundException {
        try {
            Class<?> lambdaBrowserClass = Class.forName("de.otto.jlineup.lambda.LambdaBrowser", false, CloudBrowserFactory.class.getClassLoader());
            Constructor<?> lambdaBrowserConstructor = lambdaBrowserClass.getConstructor(RunStepConfig.class, JobConfig.class, FileService.class);
            return (CloudBrowser)lambdaBrowserConstructor.newInstance(runStepConfig, jobConfig, fileService);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.debug("No LambdaBrowser reachable.", (Throwable)e);
            throw new ClassNotFoundException("Using a locally installed browser.");
        }
    }
}

