/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import com.google.common.net.InternetDomainName;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.browser.JLineupException;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.HttpCheckConfig;
import de.otto.jlineup.config.JobConfig;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JLineupHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    JLineupHttpClient() {
    }

    void callUrl(ScreenshotContext screenshotContext) throws Exception {
        CookieStore cookieStore = this.prepareCookieStore(screenshotContext);
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("relaxed").build()).setDefaultCookieStore(cookieStore).build();){
            String uri = BrowserUtils.buildUrl(screenshotContext.url, screenshotContext.urlSubPath, screenshotContext.urlConfig.envMapping);
            HttpGet request = new HttpGet(uri);
            LOG.debug("Calling uri {} for setup or cleanup", (Object)uri);
            CloseableHttpResponse response = client.execute((ClassicHttpRequest)request);
            int statusCode = response.getCode();
            LOG.debug("Status code was {}", (Object)statusCode);
            if (!HttpCheckConfig.DEFAULT_ALLOWED_CODES.contains(statusCode)) {
                throw new JLineupException("Calling setup or cleanup path " + request.getRequestUri() + " returned status code " + statusCode);
            }
            LOG.info("Setup or cleanup at {} done. Return code was: {}", (Object)request.getRequestUri(), (Object)statusCode);
        }
    }

    void checkPageAccessibility(ScreenshotContext screenshotContext, JobConfig jobConfig) throws Exception {
        HttpCheckConfig httpCheck = screenshotContext.urlConfig.httpCheck.isEnabled() ? screenshotContext.urlConfig.httpCheck : jobConfig.httpCheck;
        CookieStore cookieStore = this.prepareCookieStore(screenshotContext);
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("relaxed").build()).setDefaultCookieStore(cookieStore).build();){
            String body;
            HttpEntity entity;
            HttpGet request = new HttpGet(BrowserUtils.buildUrl(screenshotContext.url, screenshotContext.urlSubPath, screenshotContext.urlConfig.envMapping));
            CloseableHttpResponse response = client.execute((ClassicHttpRequest)request);
            int statusCode = response.getCode();
            List<Integer> allowedCodes = httpCheck.getAllowedCodes();
            if (allowedCodes == null) {
                allowedCodes = HttpCheckConfig.DEFAULT_ALLOWED_CODES;
            }
            if (!allowedCodes.contains(statusCode)) {
                throw new JLineupException("Accessibility check of " + request.getRequestUri() + " returned status code " + statusCode);
            }
            List<String> errorSignals = httpCheck.getErrorSignals();
            if (errorSignals != null && !errorSignals.isEmpty() && (entity = response.getEntity()) != null && (body = EntityUtils.toString((HttpEntity)entity)) != null) {
                for (String errorSignal : errorSignals) {
                    if (!body.contains(errorSignal)) continue;
                    throw new JLineupException("Accessibility check of " + request.getRequestUri() + " returned error signal '" + errorSignal + "' in body ");
                }
            }
            LOG.info("Accessibility of {} checked and considered good! Return code was: {}", (Object)request.getRequestUri(), (Object)statusCode);
        }
    }

    private CookieStore prepareCookieStore(ScreenshotContext screenshotContext) throws MalformedURLException {
        List<de.otto.jlineup.config.Cookie> cookies = screenshotContext.cookies;
        BasicCookieStore cookieStore = new BasicCookieStore();
        String domain = this.isUrlLocalHost(screenshotContext.url) ? "localhost" : ".".concat(InternetDomainName.from((String)new URL(screenshotContext.url).getHost()).topPrivateDomain().toString());
        if (cookies != null) {
            this.addCookiesToStore(cookies, (CookieStore)cookieStore, domain);
        }
        return cookieStore;
    }

    private boolean isUrlLocalHost(String url) {
        try {
            InetAddress address = InetAddress.getByName(new URL(url).getHost());
            return address.isAnyLocalAddress() || address.isLoopbackAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void addCookiesToStore(List<de.otto.jlineup.config.Cookie> cookies, CookieStore cookieStore, String domain) {
        for (de.otto.jlineup.config.Cookie cookie : cookies) {
            BasicClientCookie apacheCookie = new BasicClientCookie(cookie.name, cookie.value);
            apacheCookie.setAttribute("domain", "true");
            if (cookie.domain != null) {
                apacheCookie.setDomain(cookie.domain);
            } else {
                apacheCookie.setDomain(domain);
            }
            if (cookie.expiry != null) {
                apacheCookie.setExpiryDate(cookie.expiry);
            }
            if (cookie.path != null) {
                apacheCookie.setPath(cookie.path);
            }
            apacheCookie.setSecure(cookie.secure);
            cookieStore.addCookie((Cookie)apacheCookie);
        }
    }
}

