/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import de.otto.jlineup.config.JobConfig;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.logging.Level;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogErrorChecker {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void checkForErrors(WebDriver driver, JobConfig jobConfig) {
        if (jobConfig.checkForErrorsInLog) {
            LogEntries logEntries;
            LOG.debug("Checking for errors.");
            try {
                logEntries = driver.manage().logs().get("browser");
            }
            catch (UnsupportedCommandException | JsonException e) {
                logEntries = null;
            }
            if (logEntries != null && !logEntries.getAll().isEmpty() && ((LogEntry)logEntries.getAll().get(0)).getLevel().equals(Level.SEVERE)) {
                throw new WebDriverException(((LogEntry)logEntries.getAll().get(0)).getMessage());
            }
            if (!jobConfig.browser.isChrome()) return;
            driver.manage().timeouts().implicitlyWait(Duration.ZERO);
            try {
                WebElement element = driver.findElement(By.className((String)"error-code"));
                if (element == null || element.getText() == null) return;
                element.getText();
                throw new WebDriverException(element.getText());
            }
            catch (NoSuchElementException noSuchElementException) {
                return;
            }
            finally {
                driver.manage().timeouts().implicitlyWait(Duration.of(60L, ChronoUnit.SECONDS));
            }
        }
        LOG.debug("Not checking for errors in browser log.");
    }
}

