/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DeviceConfig {
    static final String DESKTOP_DEVICE_NAME = "DESKTOP";
    static final String MOBILE_DEVICE_NAME = "MOBILE";
    private static final String DEFAULT_DEVICE_NAME = "DESKTOP";
    private static final String DEFAULT_USER_AGENT = null;
    private static final boolean DEFAULT_TOUCH_OPTION = false;
    public final int width;
    public final int height;
    @JsonAlias(value={"pixelRatio"})
    public final float pixelRatio;
    @JsonAlias(value={"deviceName"})
    public final String deviceName;
    @JsonAlias(value={"userAgent"})
    public final String userAgent;
    public final boolean touch;

    public DeviceConfig() {
        this.deviceName = "DESKTOP";
        this.width = 800;
        this.height = 800;
        this.pixelRatio = 1.0f;
        this.touch = false;
        this.userAgent = DEFAULT_USER_AGENT;
    }

    private DeviceConfig(int width, int height, float pixelRatio, String deviceName, String userAgent, boolean touch) {
        this.width = width;
        this.height = height;
        this.pixelRatio = pixelRatio;
        this.deviceName = deviceName;
        this.userAgent = userAgent;
        this.touch = touch;
    }

    private DeviceConfig(Builder builder) {
        this.width = builder.width;
        this.height = builder.height;
        this.pixelRatio = builder.pixelRatio;
        this.deviceName = builder.deviceName;
        this.userAgent = builder.userAgent;
        this.touch = builder.touch;
    }

    public static DeviceConfig deviceConfig(int width, int height) {
        return DeviceConfig.deviceConfigBuilder().withWidth(width).withHeight(height).build();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getPixelRatio() {
        return this.pixelRatio;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isTouch() {
        return this.touch;
    }

    public static Builder deviceConfigBuilder() {
        return new Builder();
    }

    @JsonIgnore
    public boolean isDesktop() {
        return "DESKTOP".equalsIgnoreCase(this.deviceName.trim());
    }

    @JsonIgnore
    public boolean isMobile() {
        return !"DESKTOP".equalsIgnoreCase(this.deviceName.trim());
    }

    @JsonIgnore
    public boolean isGenericMobile() {
        return MOBILE_DEVICE_NAME.equalsIgnoreCase(this.deviceName.trim());
    }

    @JsonIgnore
    public boolean isSpecificMobile() {
        return !this.isDesktop() && !this.isGenericMobile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceConfig that = (DeviceConfig)o;
        return this.width == that.width && this.height == that.height && Float.compare(that.pixelRatio, this.pixelRatio) == 0 && this.touch == that.touch && Objects.equals(this.deviceName, that.deviceName) && Objects.equals(this.userAgent, that.userAgent);
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height, Float.valueOf(this.pixelRatio), this.deviceName, this.userAgent, this.touch);
    }

    public String toString() {
        return "DeviceConfig{width=" + this.width + ", height=" + this.height + ", pixelRatio=" + this.pixelRatio + ", deviceName='" + this.deviceName + "', userAgent='" + this.userAgent + "', touch=" + this.touch + "}";
    }

    public static final class Builder {
        private int width = 800;
        private int height = 800;
        private float pixelRatio = 1.0f;
        private String deviceName = "DESKTOP";
        private String userAgent = DEFAULT_USER_AGENT;
        private boolean touch = false;

        private Builder() {
        }

        public Builder withWidth(int val) {
            this.width = val;
            return this;
        }

        public Builder withHeight(int val) {
            this.height = val;
            return this;
        }

        @JsonAlias(value={"pixelRatio"})
        public Builder withPixelRatio(float val) {
            this.pixelRatio = val;
            return this;
        }

        @JsonAlias(value={"deviceName"})
        public Builder withDeviceName(String val) {
            this.deviceName = val;
            return this;
        }

        @JsonAlias(value={"userAgent"})
        public Builder withUserAgent(String val) {
            this.userAgent = val;
            return this;
        }

        public Builder withTouch(boolean val) {
            this.touch = val;
            return this;
        }

        public DeviceConfig build() {
            return new DeviceConfig(this);
        }
    }
}

