/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HttpCheckConfig {
    public static final List<Integer> DEFAULT_ALLOWED_CODES = Arrays.asList(200, 202, 204, 205, 206, 301, 302, 303, 304, 307, 308);
    private final boolean enabled;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final List<Integer> allowedCodes;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final List<String> errorSignals;

    public HttpCheckConfig(boolean enabled, List<Integer> allowedCodes) {
        this.enabled = enabled;
        this.allowedCodes = allowedCodes == null ? DEFAULT_ALLOWED_CODES : allowedCodes;
        this.errorSignals = null;
    }

    public HttpCheckConfig() {
        this.enabled = false;
        this.allowedCodes = null;
        this.errorSignals = null;
    }

    public HttpCheckConfig(boolean enabled) {
        this.enabled = enabled;
        this.allowedCodes = DEFAULT_ALLOWED_CODES;
        this.errorSignals = null;
    }

    private HttpCheckConfig(Builder builder) {
        this.enabled = builder.enabled;
        this.allowedCodes = builder.allowedCodes;
        this.errorSignals = builder.errorSignals;
    }

    public static Builder httpCheckConfigBuilder() {
        return new Builder();
    }

    public static Builder httpCheckConfigBuilder(HttpCheckConfig copy) {
        Builder builder = new Builder();
        builder.enabled = copy.isEnabled();
        builder.allowedCodes = copy.getAllowedCodes();
        builder.errorSignals = copy.getErrorSignals();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpCheckConfig that = (HttpCheckConfig)o;
        return this.enabled == that.enabled && Objects.equals(this.allowedCodes, that.allowedCodes) && Objects.equals(this.errorSignals, that.errorSignals);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.allowedCodes, this.errorSignals);
    }

    public String toString() {
        return "HttpCheckConfig{enabled=" + this.enabled + ", allowedCodes=" + String.valueOf(this.allowedCodes) + ", errorSignals=" + String.valueOf(this.errorSignals) + "}";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<Integer> getAllowedCodes() {
        return this.allowedCodes;
    }

    public List<String> getErrorSignals() {
        return this.errorSignals;
    }

    public static final class Builder {
        private boolean enabled;
        private List<Integer> allowedCodes;
        public List<String> errorSignals;

        private Builder() {
        }

        public Builder withEnabled(boolean val) {
            this.enabled = val;
            return this;
        }

        public Builder withAllowedCodes(List<Integer> val) {
            this.allowedCodes = val;
            return this;
        }

        public Builder withErrorSignals(List<String> val) {
            this.errorSignals = val;
            return this;
        }

        public HttpCheckConfig build() {
            return new HttpCheckConfig(this);
        }
    }
}

