/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.otto.jlineup.JacksonWrapper;
import de.otto.jlineup.browser.Browser;
import de.otto.jlineup.config.Cookie;
import de.otto.jlineup.config.DeviceConfig;
import de.otto.jlineup.config.HttpCheckConfig;
import de.otto.jlineup.config.HttpCheckFilter;
import de.otto.jlineup.config.JobConfigMixIn;
import de.otto.jlineup.config.ReportFormatFilter;
import de.otto.jlineup.config.UrlConfig;
import de.otto.jlineup.config.UrlConfigMixIn;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class JobConfig {
    static final String LINEUP_CONFIG_DEFAULT_PATH = "./lineup.json";
    static final String EXAMPLE_URL = "https://www.example.com";
    public static final int DEFAULT_WARMUP_BROWSER_CACHE_TIME = 0;
    public static final int DEFAULT_REPORT_FORMAT = 2;
    static final Browser.Type DEFAULT_BROWSER = Browser.Type.CHROME_HEADLESS;
    static final float DEFAULT_MAX_DIFF = 0.0f;
    public static final int DEFAULT_WINDOW_WIDTH = 800;
    public static final int DEFAULT_WINDOW_HEIGHT = 800;
    static final float DEFAULT_PIXEL_RATIO = 1.0f;
    static final float DEFAULT_GLOBAL_WAIT_AFTER_PAGE_LOAD = 0.0f;
    public static final String DEFAULT_PATH = "";
    public static final ImmutableList<String> DEFAULT_PATHS = ImmutableList.of((Object)"");
    static final int DEFAULT_MAX_SCROLL_HEIGHT = 100000;
    static final float DEFAULT_WAIT_AFTER_PAGE_LOAD = 0.0f;
    static final float DEFAULT_WAIT_AFTER_SCROLL = 0.0f;
    static final float DEFAULT_WAIT_FOR_NO_ANIMATION_AFTER_SCROLL = 0.0f;
    static final float DEFAULT_WAIT_FOR_FONTS_TIME = 0.0f;
    public static final double DEFAULT_MAX_ANTI_ALIAS_COLOR_DISTANCE = 2.3;
    public static final double DEFAULT_MAX_COLOR_DISTANCE = 2.3;
    static final int DEFAULT_THREADS = 0;
    static final int DEFAULT_PAGELOAD_TIMEOUT = 120;
    static final int DEFAULT_SCREENSHOT_RETRIES = 0;
    static final int DEFAULT_GLOBAL_TIMEOUT = 1800;
    public static final float DEFAULT_WAIT_FOR_SELECTORS_TIMEOUT = 10.0f;
    public static final HttpCheckConfig DEFAULT_HTTP_CHECK_CONFIG = new HttpCheckConfig();
    public final Map<String, UrlConfig> urls;
    public final Browser.Type browser;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public final String name;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public final String message;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public final String approvalLink;
    @JsonProperty(value="wait-after-page-load")
    @JsonAlias(value={"async-wait"})
    public final Float globalWaitAfterPageLoad;
    public final int pageLoadTimeout;
    public final Integer windowHeight;
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ReportFormatFilter.class)
    public final Integer reportFormat;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public final int screenshotRetries;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public final int threads;
    @JsonProperty(value="timeout")
    public final int globalTimeout;
    public final boolean debug;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public final boolean logToFile;
    public final boolean checkForErrorsInLog;
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=HttpCheckFilter.class)
    public final HttpCheckConfig httpCheck;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public final JobConfig mergeConfig;

    public JobConfig() {
        this(JobConfig.jobConfigBuilder());
    }

    private JobConfig(Builder builder) {
        this.name = builder.name;
        this.message = builder.message;
        this.approvalLink = builder.approvalLink;
        this.urls = builder.urls;
        this.browser = builder.browser;
        this.globalWaitAfterPageLoad = Float.valueOf(builder.globalWaitAfterPageLoad);
        this.pageLoadTimeout = builder.pageLoadTimeout;
        this.windowHeight = builder.windowHeight;
        this.threads = builder.threads;
        this.screenshotRetries = builder.screenshotRetries;
        this.reportFormat = builder.reportFormat;
        this.globalTimeout = builder.globalTimeout;
        this.debug = builder.debug;
        this.logToFile = builder.logToFile;
        this.checkForErrorsInLog = builder.checkForErrorsInLog;
        this.httpCheck = builder.httpCheck;
        this.mergeConfig = builder.mergeConfig;
    }

    public static String prettyPrint(JobConfig jobConfig) {
        return JacksonWrapper.serializeObject(jobConfig);
    }

    public static String prettyPrintWithAllFields(JobConfig jobConfig) {
        ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_TRAILING_COMMA, true).configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS, true).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true)).configure(JsonParser.Feature.ALLOW_COMMENTS, true)).configure(SerializationFeature.INDENT_OUTPUT, true)).build();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);
        objectMapper.addMixIn(JobConfig.class, JobConfigMixIn.class);
        objectMapper.addMixIn(UrlConfig.class, UrlConfigMixIn.class);
        try {
            return objectMapper.writeValueAsString((Object)jobConfig);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("There is a problem while writing the " + jobConfig.getClass().getCanonicalName() + " with Jackson.", e);
        }
    }

    public Map<String, UrlConfig> getUrls() {
        return this.urls;
    }

    public Browser.Type getBrowser() {
        return this.browser;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    @JsonIgnore
    public String getSanitizedMessage() {
        return this.message != null ? this.message.replace("\\n", "\n") : null;
    }

    public String getApprovalLink() {
        return this.approvalLink;
    }

    public Float getGlobalWaitAfterPageLoad() {
        return this.globalWaitAfterPageLoad;
    }

    public int getPageLoadTimeout() {
        return this.pageLoadTimeout;
    }

    public Integer getWindowHeight() {
        return this.windowHeight;
    }

    public Integer getReportFormat() {
        return this.reportFormat;
    }

    public int getScreenshotRetries() {
        return this.screenshotRetries;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getGlobalTimeout() {
        return this.globalTimeout;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isLogToFile() {
        return this.logToFile;
    }

    public boolean isCheckForErrorsInLog() {
        return this.checkForErrorsInLog;
    }

    public HttpCheckConfig getHttpCheck() {
        return this.httpCheck;
    }

    public JobConfig getMergeConfig() {
        return this.mergeConfig;
    }

    public static Builder copyOfBuilder(JobConfig jobConfig) {
        return JobConfig.jobConfigBuilder().withName(jobConfig.name).withMessage(jobConfig.message).withApprovalLink(jobConfig.approvalLink).withUrls(jobConfig.urls).withHttpCheck(jobConfig.httpCheck).withBrowser(jobConfig.browser).withGlobalWaitAfterPageLoad(jobConfig.globalWaitAfterPageLoad.floatValue()).withPageLoadTimeout(jobConfig.pageLoadTimeout).withWindowHeight(jobConfig.windowHeight).withThreads(jobConfig.threads).withScreenshotRetries(jobConfig.screenshotRetries).withReportFormat(jobConfig.reportFormat).withGlobalTimeout(jobConfig.globalTimeout).withDebug(jobConfig.debug).withLogToFile(jobConfig.logToFile).withMergeConfig(jobConfig.mergeConfig).withCheckForErrorsInLog(jobConfig.checkForErrorsInLog);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobConfig jobConfig = (JobConfig)o;
        return this.pageLoadTimeout == jobConfig.pageLoadTimeout && this.screenshotRetries == jobConfig.screenshotRetries && this.threads == jobConfig.threads && this.globalTimeout == jobConfig.globalTimeout && this.debug == jobConfig.debug && this.logToFile == jobConfig.logToFile && this.checkForErrorsInLog == jobConfig.checkForErrorsInLog && Objects.equals(this.urls, jobConfig.urls) && this.browser == jobConfig.browser && Objects.equals(this.name, jobConfig.name) && Objects.equals(this.message, jobConfig.message) && Objects.equals(this.approvalLink, jobConfig.approvalLink) && Objects.equals(this.globalWaitAfterPageLoad, jobConfig.globalWaitAfterPageLoad) && Objects.equals(this.windowHeight, jobConfig.windowHeight) && Objects.equals(this.reportFormat, jobConfig.reportFormat) && Objects.equals(this.httpCheck, jobConfig.httpCheck) && Objects.equals(this.mergeConfig, jobConfig.mergeConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.urls, this.browser, this.name, this.message, this.approvalLink, this.globalWaitAfterPageLoad, this.pageLoadTimeout, this.windowHeight, this.reportFormat, this.screenshotRetries, this.threads, this.globalTimeout, this.debug, this.logToFile, this.checkForErrorsInLog, this.httpCheck, this.mergeConfig});
    }

    public String toString() {
        return "JobConfig{urls=" + String.valueOf(this.urls) + ", browser=" + String.valueOf((Object)this.browser) + ", name='" + this.name + "', message='" + this.message + "', approvalLink='" + this.approvalLink + "', globalWaitAfterPageLoad=" + this.globalWaitAfterPageLoad + ", pageLoadTimeout=" + this.pageLoadTimeout + ", windowHeight=" + this.windowHeight + ", reportFormat=" + this.reportFormat + ", screenshotRetries=" + this.screenshotRetries + ", threads=" + this.threads + ", globalTimeout=" + this.globalTimeout + ", debug=" + this.debug + ", logToFile=" + this.logToFile + ", checkForErrorsInLog=" + this.checkForErrorsInLog + ", httpCheck=" + String.valueOf(this.httpCheck) + ", mergeConfig=" + String.valueOf(this.mergeConfig) + "}";
    }

    public static JobConfig defaultConfig() {
        return JobConfig.defaultConfig(EXAMPLE_URL);
    }

    public static JobConfig defaultConfig(String url) {
        return JobConfig.jobConfigBuilder().withName("Default").withUrls((Map<String, UrlConfig>)ImmutableMap.of((Object)url, (Object)UrlConfig.urlConfigBuilder().build())).build();
    }

    public static Builder jobConfigBuilder() {
        return new Builder();
    }

    public static JobConfig exampleConfig() {
        return JobConfig.exampleConfigBuilder().build().insertDefaults();
    }

    public static Builder exampleConfigBuilder() {
        return JobConfig.jobConfigBuilder().withName("Example").withMessage("This is an example message, which will be shown in the report.").withCheckForErrorsInLog(true).withUrls((Map<String, UrlConfig>)ImmutableMap.of((Object)EXAMPLE_URL, (Object)UrlConfig.urlConfigBuilder().withPaths((List<String>)ImmutableList.of((Object)"/")).withCookies((List<Cookie>)ImmutableList.of((Object)new Cookie("exampleCookieName", "exampleValue", "www.example.com", "/", new Date(1000L), false, false, false))).withEnvMapping((Map<String, String>)ImmutableMap.of((Object)"live", (Object)"www")).withLocalStorage((Map<String, String>)ImmutableMap.of((Object)"exampleLocalStorageKey", (Object)"value")).withSessionStorage((Map<String, String>)ImmutableMap.of((Object)"exampleSessionStorageKey", (Object)"value")).withDevices((List<DeviceConfig>)ImmutableList.of((Object)DeviceConfig.deviceConfig(850, 600), (Object)DeviceConfig.deviceConfig(1000, 850), (Object)DeviceConfig.deviceConfig(1200, 1000))).withJavaScript("console.log('This is JavaScript!')").withHttpCheck(new HttpCheckConfig(true)).withStrictColorComparison(false).withRemoveSelectors((Set<String>)ImmutableSet.of((Object)"#removeNodeWithThisId", (Object)".removeNodesWithThisClass")).withWaitForSelectors((Set<String>)ImmutableSet.of((Object)"h1")).withFailIfSelectorsNotFound(false).build()));
    }

    public static JobConfig readConfig(String workingDir, String configFileName) throws IOException {
        ArrayList<String> searchPaths = new ArrayList<String>();
        Path configFilePath = Paths.get(workingDir + "/" + configFileName, new String[0]);
        searchPaths.add(configFilePath.toString());
        if (!Files.exists(configFilePath, new LinkOption[0])) {
            configFilePath = Paths.get(configFileName, new String[0]);
            searchPaths.add(configFilePath.toString());
            if (!Files.exists(configFilePath, new LinkOption[0])) {
                configFilePath = Paths.get(LINEUP_CONFIG_DEFAULT_PATH, new String[0]);
                searchPaths.add(configFilePath.toString());
                if (!Files.exists(configFilePath, new LinkOption[0])) {
                    String cwd = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
                    throw new FileNotFoundException("JobConfig file not found. Search locations were: " + Arrays.toString(searchPaths.toArray()) + " - working dir: " + cwd);
                }
            }
        }
        BufferedReader br = new BufferedReader(new FileReader(configFilePath.toString()));
        return JacksonWrapper.deserializeConfig(br);
    }

    public JobConfig insertDefaults() {
        if (this.urls == null) {
            return this;
        }
        Builder jobConfigBuilder = JobConfig.copyOfBuilder(this).withUrls((Map<String, UrlConfig>)ImmutableMap.of());
        this.urls.forEach((url, urlConfig) -> {
            List<DeviceConfig> deviceConfigs;
            int windowHeight;
            ImmutableList windowWidths;
            UrlConfig.Builder urlConfigBuilder = UrlConfig.copyOfBuilder(urlConfig);
            if (urlConfig.url == null) {
                urlConfigBuilder.withUrl((String)url);
            }
            if ((windowWidths = urlConfig.windowWidths) == null && urlConfig.devices == null) {
                windowWidths = ImmutableList.of((Object)800);
            }
            int n = windowHeight = this.windowHeight != null ? this.windowHeight : 800;
            if (urlConfig.devices == null) {
                deviceConfigs = new ArrayList<DeviceConfig>();
                windowWidths.forEach(width -> deviceConfigs.add(DeviceConfig.deviceConfigBuilder().withWidth((int)width).withHeight(windowHeight).build()));
            } else {
                deviceConfigs = urlConfig.devices;
            }
            urlConfigBuilder.withDevices(deviceConfigs);
            urlConfigBuilder.withWindowWidths(null);
            Object paths = urlConfig.paths != null ? urlConfig.paths : DEFAULT_PATHS;
            urlConfigBuilder.withPaths((List<String>)paths);
            jobConfigBuilder.addUrlConfig((String)url, urlConfigBuilder.build());
        });
        jobConfigBuilder.withWindowHeight(null);
        return jobConfigBuilder.build();
    }

    public JobConfig sanitize() {
        return JobConfig.copyOfBuilder(this).withUrls((Map)this.urls.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((UrlConfig)entry.getValue()).sanitize()))).build();
    }

    public static final class Builder {
        private String name = null;
        private String message = null;
        private String approvalLink = null;
        private Map<String, UrlConfig> urls = null;
        private Browser.Type browser = DEFAULT_BROWSER;
        private float globalWaitAfterPageLoad = 0.0f;
        private int pageLoadTimeout = 120;
        private Integer windowHeight = null;
        private int reportFormat = 2;
        private int screenshotRetries = 0;
        private int threads = 0;
        private int globalTimeout = 1800;
        private boolean debug = false;
        private boolean logToFile = false;
        private boolean checkForErrorsInLog = false;
        private HttpCheckConfig httpCheck = DEFAULT_HTTP_CHECK_CONFIG;
        public JobConfig mergeConfig;

        private Builder() {
        }

        public Builder withName(String val) {
            this.name = val;
            return this;
        }

        public Builder withMessage(String val) {
            this.message = val;
            return this;
        }

        public Builder withApprovalLink(String val) {
            this.approvalLink = val;
            return this;
        }

        public Builder withUrls(Map<String, UrlConfig> val) {
            this.urls = val;
            return this;
        }

        public Builder withBrowser(Browser.Type val) {
            this.browser = val;
            return this;
        }

        @JsonProperty(value="wait-after-page-load")
        @JsonAlias(value={"async-wait"})
        public Builder withGlobalWaitAfterPageLoad(float val) {
            this.globalWaitAfterPageLoad = val;
            return this;
        }

        public Builder withPageLoadTimeout(int val) {
            this.pageLoadTimeout = val;
            return this;
        }

        public Builder withWindowHeight(Integer val) {
            this.windowHeight = val;
            return this;
        }

        @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ReportFormatFilter.class)
        public Builder withReportFormat(int val) {
            this.reportFormat = val;
            return this;
        }

        public Builder withScreenshotRetries(int val) {
            this.screenshotRetries = val;
            return this;
        }

        public Builder withThreads(int val) {
            this.threads = val;
            return this;
        }

        public Builder withDebug(boolean val) {
            this.debug = val;
            return this;
        }

        public Builder withLogToFile(boolean val) {
            this.logToFile = val;
            return this;
        }

        @JsonProperty(value="timeout")
        public Builder withGlobalTimeout(int val) {
            this.globalTimeout = val;
            return this;
        }

        public Builder withCheckForErrorsInLog(boolean val) {
            this.checkForErrorsInLog = val;
            return this;
        }

        @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=HttpCheckFilter.class)
        public Builder withHttpCheck(HttpCheckConfig val) {
            this.httpCheck = val;
            return this;
        }

        public Builder withMergeConfig(JobConfig val) {
            this.mergeConfig = val;
            return this;
        }

        public JobConfig build() {
            return new JobConfig(this);
        }

        public Builder addUrlConfig(String url, UrlConfig urlConfig) {
            this.urls = this.urls == null ? ImmutableMap.of((Object)url, (Object)urlConfig) : ImmutableMap.builder().putAll(this.urls).put((Object)url, (Object)urlConfig).build();
            return this;
        }
    }
}

