/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import de.otto.jlineup.config.DeviceConfig;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.UrlConfig;
import de.otto.jlineup.exceptions.ValidationError;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobConfigValidator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void validateJobConfig(JobConfig jobConfig) {
        if (jobConfig.urls == null || jobConfig.urls.isEmpty()) {
            throw new ValidationError("No URLs configured.");
        }
        if (jobConfig.windowHeight != null && (jobConfig.windowHeight < 100 || jobConfig.windowHeight > 10000)) {
            throw new ValidationError(String.format("Configured window height is invalid: %d. Valid values are between 100 and 10000", jobConfig.windowHeight));
        }
        for (Map.Entry<String, UrlConfig> urlConfigEntry : jobConfig.urls.entrySet()) {
            UrlConfig urlConfig2 = urlConfigEntry.getValue();
            String url = urlConfig2.url;
            for (Integer width : urlConfig2.windowWidths != null ? urlConfig2.windowWidths : urlConfig2.devices.stream().map(d -> d.width).collect(Collectors.toList())) {
                if (width >= 10 && width <= 10000) continue;
                throw new ValidationError(String.format("One of the configured window widths for %s is invalid: %d. Valid values are between 10 and 10000", url, width));
            }
            if (urlConfig2.waitAfterPageLoad > 20.0f || urlConfig2.waitAfterPageLoad < 0.0f) {
                throw new ValidationError(String.format("Configured wait after page load time of %f seconds for %s is invalid. Valid values are between 0 and 20.", Float.valueOf(urlConfig2.waitAfterPageLoad), url));
            }
            if (urlConfig2.waitAfterScroll > 20.0f || urlConfig2.waitAfterScroll < 0.0f) {
                throw new ValidationError(String.format("Configured wait after scroll time of %f seconds for %s is invalid. Valid values are between 0 and 20.", Float.valueOf(urlConfig2.waitAfterScroll), url));
            }
            if (urlConfig2.waitForFontsTime > 20.0f || urlConfig2.waitForFontsTime < 0.0f) {
                throw new ValidationError(String.format("Configured wait for fonts time of %f seconds for %s is invalid. Valid values are between 0 and 20.", Float.valueOf(urlConfig2.waitForFontsTime), url));
            }
            if (urlConfig2.maxScrollHeight >= 0) continue;
            throw new ValidationError(String.format("Configured max scroll height (%d) for %s must not be negative)", urlConfig2.maxScrollHeight, url));
        }
        jobConfig.urls.forEach((urlKey, urlConfig) -> JobConfigValidator.validateUrlConfig(jobConfig, urlKey));
    }

    private static void validateUrlConfig(JobConfig jobConfig, String urlKey) {
        UrlConfig urlConfig = jobConfig.urls.get(urlKey);
        if (urlConfig.devices != null && !urlConfig.devices.isEmpty() && urlConfig.windowWidths != null) {
            throw new ValidationError("URL: " + urlKey + "\nDon't mix 'window-widths' (aliases are 'widths' or 'resolutions') and 'devices'.");
        }
        if (urlConfig.devices != null) {
            urlConfig.devices.forEach(deviceConfig -> JobConfigValidator.validateDeviceConfig(jobConfig, urlKey, deviceConfig));
        }
    }

    private static void validateDeviceConfig(JobConfig jobConfig, String urlKey, DeviceConfig deviceConfig) {
        if (deviceConfig.isMobile()) {
            if (!deviceConfig.isGenericMobile() && deviceConfig.userAgent != null) {
                throw new ValidationError("URLConfig: " + urlKey + "\nDevice: " + deviceConfig.deviceName + "\nReason: If you choose a defined device name, the user agent is chosen automatically and can't be overridden.");
            }
            if (deviceConfig.isMobile() && !jobConfig.browser.isChrome() && !deviceConfig.isGenericMobile()) {
                throw new ValidationError("Mobile emulation is only supported by Chrome/Chromium. You specified " + jobConfig.browser.name() + " as browser.");
            }
        }
    }
}

