/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;
import de.otto.jlineup.config.Cookie;
import de.otto.jlineup.config.DeviceConfig;
import de.otto.jlineup.config.HttpCheckConfig;
import de.otto.jlineup.config.HttpCheckFilter;
import de.otto.jlineup.config.JobConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class UrlConfig {
    public final String url;
    public final List<String> paths;
    public final List<String> setupPaths;
    public final List<String> cleanupPaths;
    public final double maxDiff;
    public final List<Cookie> cookies;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final List<List<Cookie>> alternatingCookies;
    public final Map<String, String> envMapping;
    public final Map<String, String> localStorage;
    public final Map<String, String> sessionStorage;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final List<Integer> windowWidths;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final List<DeviceConfig> devices;
    public final int maxScrollHeight;
    public final float waitAfterPageLoad;
    public final float waitAfterScroll;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public final float waitForNoAnimationAfterScroll;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public final float warmupBrowserCacheTime;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public final float waitForFontsTime;
    @JsonProperty(value="javascript")
    public final String javaScript;
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=HttpCheckFilter.class)
    public final HttpCheckConfig httpCheck;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public final boolean hideImages;
    public final Set<String> removeSelectors;
    public final Set<String> waitForSelectors;
    public final float waitForSelectorsTimeout;
    public final boolean failIfSelectorsNotFound;
    public final boolean ignoreAntiAliasing;
    public final double maxAntiAliasColorDistance;
    public final boolean strictColorComparison;
    public final double maxColorDistance;

    private UrlConfig() {
        this.url = null;
        this.paths = null;
        this.setupPaths = null;
        this.cleanupPaths = null;
        this.maxDiff = 0.0;
        this.cookies = null;
        this.alternatingCookies = null;
        this.envMapping = null;
        this.localStorage = null;
        this.sessionStorage = null;
        this.windowWidths = null;
        this.devices = null;
        this.maxScrollHeight = 100000;
        this.waitAfterPageLoad = 0.0f;
        this.waitAfterScroll = 0.0f;
        this.waitForNoAnimationAfterScroll = 0.0f;
        this.warmupBrowserCacheTime = 0.0f;
        this.waitForFontsTime = 0.0f;
        this.javaScript = null;
        this.httpCheck = JobConfig.DEFAULT_HTTP_CHECK_CONFIG;
        this.hideImages = false;
        this.removeSelectors = null;
        this.waitForSelectors = null;
        this.waitForSelectorsTimeout = 10.0f;
        this.failIfSelectorsNotFound = false;
        this.ignoreAntiAliasing = false;
        this.maxAntiAliasColorDistance = 2.3;
        this.strictColorComparison = false;
        this.maxColorDistance = 2.3;
    }

    private UrlConfig(Builder builder) {
        this.url = builder.url;
        this.paths = builder.paths;
        this.setupPaths = builder.setupPaths;
        this.cleanupPaths = builder.cleanupPaths;
        this.maxDiff = builder.maxDiff;
        this.cookies = builder.cookies;
        this.alternatingCookies = builder.alternatingCookies;
        this.envMapping = builder.envMapping;
        this.localStorage = builder.localStorage;
        this.sessionStorage = builder.sessionStorage;
        this.windowWidths = builder.windowWidths;
        this.devices = builder.devices;
        this.maxScrollHeight = builder.maxScrollHeight;
        this.waitAfterPageLoad = builder.waitAfterPageLoad;
        this.waitAfterScroll = builder.waitAfterScroll;
        this.waitForNoAnimationAfterScroll = builder.waitForNoAnimationAfterScroll;
        this.warmupBrowserCacheTime = builder.warmupBrowserCacheTime;
        this.waitForFontsTime = builder.waitForFontsTime;
        this.javaScript = builder.javaScript;
        this.httpCheck = builder.httpCheck;
        this.hideImages = builder.hideImages;
        this.ignoreAntiAliasing = builder.ignoreAntiAliasing;
        this.maxAntiAliasColorDistance = builder.maxAntiAliasColorDistance;
        this.strictColorComparison = builder.strictColorComparison;
        this.maxColorDistance = builder.maxColorDistance;
        this.removeSelectors = builder.removeSelectors;
        this.waitForSelectors = builder.waitForSelectors;
        this.waitForSelectorsTimeout = builder.waitForSelectorsTimeout;
        this.failIfSelectorsNotFound = builder.failIfSelectorsNotFound;
    }

    public String getUrl() {
        return this.url;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public List<String> getSetupPaths() {
        return this.setupPaths;
    }

    public List<String> getCleanupPaths() {
        return this.cleanupPaths;
    }

    public double getMaxDiff() {
        return this.maxDiff;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public List<List<Cookie>> getAlternatingCookies() {
        return this.alternatingCookies;
    }

    public Map<String, String> getEnvMapping() {
        return this.envMapping;
    }

    public Map<String, String> getLocalStorage() {
        return this.localStorage;
    }

    public Map<String, String> getSessionStorage() {
        return this.sessionStorage;
    }

    public List<Integer> getWindowWidths() {
        return this.windowWidths;
    }

    public List<DeviceConfig> getDevices() {
        return this.devices;
    }

    public int getMaxScrollHeight() {
        return this.maxScrollHeight;
    }

    public float getWaitAfterPageLoad() {
        return this.waitAfterPageLoad;
    }

    public float getWaitAfterScroll() {
        return this.waitAfterScroll;
    }

    public float getWaitForNoAnimationAfterScroll() {
        return this.waitForNoAnimationAfterScroll;
    }

    public float getWarmupBrowserCacheTime() {
        return this.warmupBrowserCacheTime;
    }

    public float getWaitForFontsTime() {
        return this.waitForFontsTime;
    }

    public String getJavaScript() {
        return this.javaScript;
    }

    public HttpCheckConfig getHttpCheck() {
        return this.httpCheck;
    }

    public boolean isHideImages() {
        return this.hideImages;
    }

    public boolean isIgnoreAntiAliasing() {
        return this.ignoreAntiAliasing;
    }

    public double getMaxAntiAliasColorDistance() {
        return this.maxAntiAliasColorDistance;
    }

    public boolean isStrictColorComparison() {
        return this.strictColorComparison;
    }

    public double getMaxColorDistance() {
        return this.maxColorDistance;
    }

    public Set<String> getRemoveSelectors() {
        return this.removeSelectors;
    }

    public Set<String> getWaitForSelectors() {
        return this.waitForSelectors;
    }

    public float getWaitForSelectorsTimeout() {
        return this.waitForSelectorsTimeout;
    }

    public boolean isFailIfSelectorsNotFound() {
        return this.failIfSelectorsNotFound;
    }

    public static Builder urlConfigBuilder() {
        return new Builder();
    }

    public static Builder copyOfBuilder(UrlConfig copy) {
        Builder builder = new Builder();
        builder.url = copy.url;
        builder.setupPaths = copy.setupPaths;
        builder.cleanupPaths = copy.cleanupPaths;
        builder.paths = copy.paths;
        builder.maxDiff = copy.maxDiff;
        builder.cookies = copy.cookies;
        builder.alternatingCookies = copy.alternatingCookies;
        builder.envMapping = copy.envMapping;
        builder.localStorage = copy.localStorage;
        builder.sessionStorage = copy.sessionStorage;
        builder.windowWidths = copy.windowWidths;
        builder.devices = copy.devices;
        builder.maxScrollHeight = copy.maxScrollHeight;
        builder.waitAfterPageLoad = copy.waitAfterPageLoad;
        builder.waitAfterScroll = copy.waitAfterScroll;
        builder.waitForNoAnimationAfterScroll = copy.waitForNoAnimationAfterScroll;
        builder.warmupBrowserCacheTime = copy.warmupBrowserCacheTime;
        builder.waitForFontsTime = copy.waitForFontsTime;
        builder.javaScript = copy.javaScript;
        builder.httpCheck = copy.httpCheck;
        builder.hideImages = copy.hideImages;
        builder.ignoreAntiAliasing = copy.ignoreAntiAliasing;
        builder.maxAntiAliasColorDistance = copy.maxAntiAliasColorDistance;
        builder.strictColorComparison = copy.strictColorComparison;
        builder.maxColorDistance = copy.maxColorDistance;
        builder.removeSelectors = copy.removeSelectors;
        builder.waitForSelectors = copy.waitForSelectors;
        builder.waitForSelectorsTimeout = copy.waitForSelectorsTimeout;
        builder.failIfSelectorsNotFound = copy.failIfSelectorsNotFound;
        return builder;
    }

    public UrlConfig sanitize() {
        return UrlConfig.copyOfBuilder(this).withCookies(this.cookies != null ? this.cookies.stream().map(Cookie::sanitize).collect(Collectors.toList()) : null).withAlternatingCookies(this.alternatingCookies != null ? this.alternatingCookies.stream().map(alternatingCookies -> alternatingCookies.stream().map(Cookie::sanitize).collect(Collectors.toList())).collect(Collectors.toList()) : null).withLocalStorage(this.localStorage != null ? this.localStorage.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> "*****")) : null).withSessionStorage(this.sessionStorage != null ? this.sessionStorage.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> "*****")) : null).build();
    }

    public String toString() {
        return "UrlConfig{url='" + this.url + "', paths=" + String.valueOf(this.paths) + ", setupPaths=" + String.valueOf(this.setupPaths) + ", cleanupPaths=" + String.valueOf(this.cleanupPaths) + ", maxDiff=" + this.maxDiff + ", cookies=" + String.valueOf(this.cookies) + ", alternatingCookies=" + String.valueOf(this.alternatingCookies) + ", envMapping=" + String.valueOf(this.envMapping) + ", localStorage=" + String.valueOf(this.localStorage) + ", sessionStorage=" + String.valueOf(this.sessionStorage) + ", windowWidths=" + String.valueOf(this.windowWidths) + ", devices=" + String.valueOf(this.devices) + ", maxScrollHeight=" + this.maxScrollHeight + ", waitAfterPageLoad=" + this.waitAfterPageLoad + ", waitAfterScroll=" + this.waitAfterScroll + ", waitForNoAnimationAfterScroll=" + this.waitForNoAnimationAfterScroll + ", warmupBrowserCacheTime=" + this.warmupBrowserCacheTime + ", waitForFontsTime=" + this.waitForFontsTime + ", javaScript='" + this.javaScript + "', httpCheck=" + String.valueOf(this.httpCheck) + ", hideImages=" + this.hideImages + ", removeSelectors=" + String.valueOf(this.removeSelectors) + ", waitForSelectors=" + String.valueOf(this.waitForSelectors) + ", waitForSelectorsTimeout=" + this.waitForSelectorsTimeout + ", failIfSelectorsNotFound=" + this.failIfSelectorsNotFound + ", ignoreAntiAliasing=" + this.ignoreAntiAliasing + ", maxAntiAliasColorDistance=" + this.maxAntiAliasColorDistance + ", strictColorComparison=" + this.strictColorComparison + ", maxColorDistance=" + this.maxColorDistance + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlConfig urlConfig = (UrlConfig)o;
        return Double.compare(this.maxDiff, urlConfig.maxDiff) == 0 && this.maxScrollHeight == urlConfig.maxScrollHeight && Float.compare(this.waitAfterPageLoad, urlConfig.waitAfterPageLoad) == 0 && Float.compare(this.waitAfterScroll, urlConfig.waitAfterScroll) == 0 && Float.compare(this.waitForNoAnimationAfterScroll, urlConfig.waitForNoAnimationAfterScroll) == 0 && Float.compare(this.warmupBrowserCacheTime, urlConfig.warmupBrowserCacheTime) == 0 && Float.compare(this.waitForFontsTime, urlConfig.waitForFontsTime) == 0 && this.hideImages == urlConfig.hideImages && Float.compare(this.waitForSelectorsTimeout, urlConfig.waitForSelectorsTimeout) == 0 && this.failIfSelectorsNotFound == urlConfig.failIfSelectorsNotFound && this.ignoreAntiAliasing == urlConfig.ignoreAntiAliasing && Double.compare(this.maxAntiAliasColorDistance, urlConfig.maxAntiAliasColorDistance) == 0 && this.strictColorComparison == urlConfig.strictColorComparison && Double.compare(this.maxColorDistance, urlConfig.maxColorDistance) == 0 && Objects.equals(this.url, urlConfig.url) && Objects.equals(this.paths, urlConfig.paths) && Objects.equals(this.setupPaths, urlConfig.setupPaths) && Objects.equals(this.cleanupPaths, urlConfig.cleanupPaths) && Objects.equals(this.cookies, urlConfig.cookies) && Objects.equals(this.alternatingCookies, urlConfig.alternatingCookies) && Objects.equals(this.envMapping, urlConfig.envMapping) && Objects.equals(this.localStorage, urlConfig.localStorage) && Objects.equals(this.sessionStorage, urlConfig.sessionStorage) && Objects.equals(this.windowWidths, urlConfig.windowWidths) && Objects.equals(this.devices, urlConfig.devices) && Objects.equals(this.javaScript, urlConfig.javaScript) && Objects.equals(this.httpCheck, urlConfig.httpCheck) && Objects.equals(this.removeSelectors, urlConfig.removeSelectors) && Objects.equals(this.waitForSelectors, urlConfig.waitForSelectors);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.paths, this.setupPaths, this.cleanupPaths, this.maxDiff, this.cookies, this.alternatingCookies, this.envMapping, this.localStorage, this.sessionStorage, this.windowWidths, this.devices, this.maxScrollHeight, Float.valueOf(this.waitAfterPageLoad), Float.valueOf(this.waitAfterScroll), Float.valueOf(this.waitForNoAnimationAfterScroll), Float.valueOf(this.warmupBrowserCacheTime), Float.valueOf(this.waitForFontsTime), this.javaScript, this.httpCheck, this.hideImages, this.removeSelectors, this.waitForSelectors, Float.valueOf(this.waitForSelectorsTimeout), this.failIfSelectorsNotFound, this.ignoreAntiAliasing, this.maxAntiAliasColorDistance, this.strictColorComparison, this.maxColorDistance);
    }

    public static final class Builder {
        private String url = null;
        private List<String> paths = null;
        private List<String> setupPaths = Collections.emptyList();
        private List<String> cleanupPaths = Collections.emptyList();
        private double maxDiff = 0.0;
        private List<Cookie> cookies;
        private List<List<Cookie>> alternatingCookies = Collections.emptyList();
        private Map<String, String> envMapping;
        private Map<String, String> localStorage;
        private Map<String, String> sessionStorage;
        private List<Integer> windowWidths;
        private List<DeviceConfig> devices;
        private int maxScrollHeight = 100000;
        private float waitAfterPageLoad = 0.0f;
        private float waitAfterScroll = 0.0f;
        private float waitForNoAnimationAfterScroll = 0.0f;
        private float warmupBrowserCacheTime = 0.0f;
        private float waitForFontsTime = 0.0f;
        private String javaScript;
        private HttpCheckConfig httpCheck = JobConfig.DEFAULT_HTTP_CHECK_CONFIG;
        private boolean hideImages;
        private boolean ignoreAntiAliasing;
        private double maxAntiAliasColorDistance = 2.3;
        private boolean strictColorComparison;
        private double maxColorDistance = 2.3;
        private Set<String> removeSelectors;
        private Set<String> waitForSelectors;
        private float waitForSelectorsTimeout = 10.0f;
        private boolean failIfSelectorsNotFound;

        private Builder() {
        }

        public Builder withUrl(String val) {
            this.url = val;
            return this;
        }

        public Builder withPaths(List<String> val) {
            this.paths = val;
            return this;
        }

        public Builder withSetupPaths(List<String> val) {
            this.setupPaths = val;
            return this;
        }

        public Builder withCleanupPaths(List<String> val) {
            this.cleanupPaths = val;
            return this;
        }

        public Builder withMaxDiff(double val) {
            this.maxDiff = val;
            return this;
        }

        public Builder withCookies(List<Cookie> val) {
            this.cookies = val;
            return this;
        }

        public Builder withCookie(Cookie val) {
            this.cookies = Collections.singletonList(val);
            return this;
        }

        public Builder withAlternatingCookies(List<List<Cookie>> val) {
            this.alternatingCookies = val != null ? val.stream().map(alternatingCookies -> alternatingCookies != null ? alternatingCookies.stream().map(cookie -> Cookie.copyOfBuilder(cookie).withScreenshotContextGiving(true).build()).collect(Collectors.toList()) : null).collect(Collectors.toList()) : null;
            return this;
        }

        public Builder withEnvMapping(Map<String, String> val) {
            this.envMapping = val;
            return this;
        }

        public Builder withHttpCheck(HttpCheckConfig val) {
            this.httpCheck = val;
            return this;
        }

        public Builder withLocalStorage(Map<String, String> val) {
            this.localStorage = val;
            return this;
        }

        public Builder withSessionStorage(Map<String, String> val) {
            this.sessionStorage = val;
            return this;
        }

        @JsonAlias(value={"resolutions", "widths"})
        public Builder withWindowWidths(List<Integer> val) {
            this.windowWidths = val;
            return this;
        }

        public Builder withDevices(List<DeviceConfig> val) {
            this.devices = val;
            return this;
        }

        public Builder addDeviceConfig(DeviceConfig deviceConfig) {
            if (this.devices == null) {
                this.devices = new ArrayList<DeviceConfig>();
            }
            this.devices.add(deviceConfig);
            return this;
        }

        public Builder withMaxScrollHeight(int val) {
            this.maxScrollHeight = val;
            return this;
        }

        public Builder withWaitAfterPageLoad(float val) {
            this.waitAfterPageLoad = val;
            return this;
        }

        public Builder withWaitAfterScroll(float val) {
            this.waitAfterScroll = val;
            return this;
        }

        public Builder withWaitForNoAnimationAfterScroll(float val) {
            this.waitForNoAnimationAfterScroll = val;
            return this;
        }

        public Builder withWarmupBrowserCacheTime(float val) {
            this.warmupBrowserCacheTime = val;
            return this;
        }

        public Builder withWaitForFontsTime(float val) {
            this.waitForFontsTime = val;
            return this;
        }

        @JsonProperty(value="javascript")
        public Builder withJavaScript(String val) {
            this.javaScript = val;
            return this;
        }

        public Builder withHideImages(boolean val) {
            this.hideImages = val;
            return this;
        }

        public Builder withIgnoreAntiAliasing(boolean val) {
            this.ignoreAntiAliasing = val;
            return this;
        }

        public Builder withMaxAntiAliasColorDistance(double val) {
            this.maxAntiAliasColorDistance = val;
            return this;
        }

        public Builder withStrictColorComparison(boolean val) {
            this.strictColorComparison = val;
            return this;
        }

        public Builder withMaxColorDistance(double val) {
            this.maxColorDistance = val;
            return this;
        }

        public Builder withRemoveSelectors(Set<String> val) {
            this.removeSelectors = val;
            return this;
        }

        public Builder withWaitForSelectors(Set<String> val) {
            this.waitForSelectors = val;
            return this;
        }

        public Builder withWaitForSelectorsTimeout(float val) {
            this.waitForSelectorsTimeout = val;
            return this;
        }

        public Builder withFailIfSelectorsNotFound(boolean val) {
            this.failIfSelectorsNotFound = val;
            return this;
        }

        public Builder withPath(String val) {
            this.paths = ImmutableList.of((Object)val);
            return this;
        }

        public UrlConfig build() {
            return new UrlConfig(this);
        }
    }
}

