/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import de.otto.jlineup.JacksonWrapper;
import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.browser.BrowserStep;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.RunStep;
import de.otto.jlineup.file.FileTracker;
import de.otto.jlineup.file.FileUtils;
import de.otto.jlineup.file.ScreenshotContextFileTracker;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String FILE_SEPARATOR = FileSystems.getDefault().getSeparator();
    public static final String DIVIDER = "_";
    public static final String PNG_EXTENSION = ".png";
    private static final int MAX_URL_TO_FILENAME_LENGTH = 180;
    public static final String DEFAULT_FILETRACKER_FILENAME = "files.json";
    public static final String REPORT_HTML_FILENAME = "report.html";
    public static final String LEGACY_REPORT_HTML_FILENAME = "report_legacy.html";
    public static final String REPORT_JSON_FILENAME = "report.json";
    private final RunStepConfig runStepConfig;
    private final FileTracker fileTracker;
    private final String filetrackerFilename;

    public FileTracker getFileTracker() {
        return this.fileTracker;
    }

    public ScreenshotContext getRecordedContext(int hash) {
        return this.fileTracker.getScreenshotContextFileTracker((int)hash).screenshotContext;
    }

    public FileService(RunStepConfig runStepConfig, JobConfig jobConfig) {
        this(runStepConfig, jobConfig, DEFAULT_FILETRACKER_FILENAME);
    }

    public FileService(RunStepConfig runStepConfig, JobConfig jobConfig, String filetrackerFilename) {
        this.runStepConfig = runStepConfig;
        this.filetrackerFilename = filetrackerFilename;
        if (!(runStepConfig.isKeepExisting() || runStepConfig.getStep() != RunStep.before && runStepConfig.getStep() != RunStep.after_only)) {
            this.fileTracker = FileTracker.create(jobConfig);
        } else {
            FileTracker fileTrackerFromFile;
            Path path = Paths.get(runStepConfig.getWorkingDirectory(), runStepConfig.getReportDirectory(), this.filetrackerFilename);
            try {
                fileTrackerFromFile = JacksonWrapper.readFileTrackerFile(path.toFile());
            }
            catch (Exception e) {
                if (e.getCause() instanceof FileNotFoundException && runStepConfig.isKeepExisting()) {
                    LOG.info("Nothing to keep although --keep-existing was specified. No former run found.");
                    fileTrackerFromFile = FileTracker.create(jobConfig);
                }
                throw e;
            }
            this.fileTracker = runStepConfig.isKeepExisting() ? new FileTracker(jobConfig, fileTrackerFromFile.contexts, fileTrackerFromFile.browsers) : fileTrackerFromFile;
        }
    }

    @VisibleForTesting
    Path createDirIfNotExists(String dirPath) throws IOException {
        Path path = Paths.get(dirPath, new String[0]);
        Files.createDirectories(path, new FileAttribute[0]);
        return path;
    }

    public void createOrClearReportDirectory(boolean keepExisting) throws IOException {
        this.createOrClearDirectoryBelowWorkingDir(this.runStepConfig.getWorkingDirectory(), this.runStepConfig.getReportDirectory(), keepExisting);
    }

    @VisibleForTesting
    Path getScreenshotDirectory() {
        return Paths.get(String.format("%s/%s", this.runStepConfig.getWorkingDirectory(), this.runStepConfig.getScreenshotsDirectory()), new String[0]);
    }

    private Path getReportDirectory() {
        return Paths.get(String.format("%s/%s", this.runStepConfig.getWorkingDirectory(), this.runStepConfig.getReportDirectory()), new String[0]);
    }

    public void createWorkingDirectoryIfNotExists() throws IOException {
        try {
            this.createDirIfNotExists(this.runStepConfig.getWorkingDirectory());
        }
        catch (IOException e) {
            throw new IOException("Could not create or open working directory.", e);
        }
    }

    public void createOrClearScreenshotsDirectory(boolean keepExisting) throws IOException {
        this.createOrClearDirectoryBelowWorkingDir(this.runStepConfig.getWorkingDirectory(), this.runStepConfig.getScreenshotsDirectory(), keepExisting);
    }

    private void createOrClearDirectoryBelowWorkingDir(String workingDirectory, String subDirectory, boolean keepExisting) throws IOException {
        try {
            String subDirectoryPath = workingDirectory + FILE_SEPARATOR + subDirectory;
            this.createDirIfNotExists(subDirectoryPath);
            if (!keepExisting) {
                FileUtils.clearDirectory(subDirectoryPath);
            }
        }
        catch (IOException e) {
            throw new IOException("Could not create or open " + subDirectory + " directory.", e);
        }
    }

    @VisibleForTesting
    static String generateScreenshotFileName(String url, String urlSubPath, int width, int yPosition, String type) {
        String fileName = FileService.generateScreenshotFileNamePrefix(url, urlSubPath) + String.format("%04d", width) + DIVIDER + String.format("%05d", yPosition) + DIVIDER + type;
        fileName = fileName + PNG_EXTENSION;
        return fileName;
    }

    public static String generateScreenshotFileNamePrefix(String url, String urlSubPath) {
        String hash = Hashing.sha1().hashString((CharSequence)(url + urlSubPath), Charsets.UTF_8).toString().substring(0, 7);
        if (urlSubPath.equals("/") || urlSubPath.equals("")) {
            urlSubPath = "root";
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        Object fileNamePrefix = url + DIVIDER + urlSubPath + DIVIDER;
        fileNamePrefix = ((String)fileNamePrefix).replace("://", DIVIDER);
        fileNamePrefix = ((String)fileNamePrefix).replaceAll("[^A-Za-z0-9\\-_]", DIVIDER);
        if (((String)(fileNamePrefix = ((String)fileNamePrefix).replace("\\", "").replace("/", "").replace(".", ""))).length() > 180) {
            fileNamePrefix = ((String)fileNamePrefix).substring(0, 180) + DIVIDER;
        }
        fileNamePrefix = (String)fileNamePrefix + hash + DIVIDER;
        return fileNamePrefix;
    }

    @VisibleForTesting
    String getScreenshotPath(String url, String urlSubPath, int width, int yPosition, String step) {
        return this.runStepConfig.getWorkingDirectory() + (this.runStepConfig.getWorkingDirectory().endsWith(FILE_SEPARATOR) ? "" : FILE_SEPARATOR) + this.runStepConfig.getScreenshotsDirectory() + (this.runStepConfig.getScreenshotsDirectory().endsWith(FILE_SEPARATOR) ? "" : FILE_SEPARATOR) + FileService.generateScreenshotFileName(url, urlSubPath, width, yPosition, step);
    }

    private String getScreenshotPath(String fileName) {
        return this.runStepConfig.getWorkingDirectory() + (this.runStepConfig.getWorkingDirectory().endsWith(FILE_SEPARATOR) ? "" : FILE_SEPARATOR) + this.runStepConfig.getScreenshotsDirectory() + (this.runStepConfig.getScreenshotsDirectory().endsWith(FILE_SEPARATOR) ? "" : FILE_SEPARATOR) + fileName;
    }

    public BufferedImage readScreenshot(String fileName) throws IOException {
        return ImageIO.read(new File(this.getScreenshotPath(fileName)));
    }

    private static void writeScreenshot(String fileName, BufferedImage image) throws IOException {
        LOG.debug("Writing screenshot to {}", (Object)fileName);
        File screenshotFile = new File(fileName);
        ImageIO.write((RenderedImage)image, "png", screenshotFile);
    }

    public String writeScreenshot(ScreenshotContext screenshotContext, BufferedImage image, int yPosition) throws IOException {
        this.createDirIfNotExists(this.getScreenshotDirectory().toString() + FILE_SEPARATOR + screenshotContext.contextHash());
        String fileName = this.getScreenshotFilenameBelowScreenshotsDir(screenshotContext, yPosition);
        FileService.writeScreenshot(Paths.get(this.getScreenshotDirectory().toString(), fileName).toString(), image);
        this.fileTracker.addScreenshot(screenshotContext, fileName, yPosition);
        return fileName;
    }

    private String getScreenshotFilenameBelowScreenshotsDir(ScreenshotContext screenshotContext, int yPosition) {
        return screenshotContext.contextHash() + FILE_SEPARATOR + FileService.generateScreenshotFileName(screenshotContext.url, screenshotContext.urlSubPath, screenshotContext.deviceConfig.width, yPosition, screenshotContext.step.name());
    }

    public String getRelativePathFromReportDirToScreenshotsDir() {
        Path screenshotDirectory = this.getScreenshotDirectory().toAbsolutePath();
        Path reportDirectory = this.getReportDirectory().toAbsolutePath();
        Path relative = reportDirectory.relativize(screenshotDirectory);
        return relative.toString().equals("") ? "" : String.valueOf(relative) + FILE_SEPARATOR;
    }

    public void writeJsonReport(String reportJson) throws FileNotFoundException {
        try (PrintStream out = new PrintStream(new FileOutputStream(String.valueOf(this.getReportDirectory()) + FILE_SEPARATOR + REPORT_JSON_FILENAME));){
            out.print(reportJson);
        }
    }

    public void writeHtmlReportLegacy(String htmlReport) throws FileNotFoundException {
        this.writeHtmlReport(htmlReport, LEGACY_REPORT_HTML_FILENAME);
    }

    public void writeHtmlReport(String htmlReport, String filename) throws FileNotFoundException {
        try (PrintStream out = new PrintStream(new FileOutputStream(String.valueOf(this.getReportDirectory()) + FILE_SEPARATOR + filename));){
            out.print(htmlReport);
        }
    }

    public void writeHtml(String html, RunStep step) throws FileNotFoundException {
        try (PrintStream out = new PrintStream(new FileOutputStream(String.valueOf(this.getReportDirectory()) + FILE_SEPARATOR + String.valueOf((Object)step) + ".html"));){
            out.print(html);
        }
    }

    public void writeFileTrackerData() throws IOException {
        this.writeFileTrackerData(this.filetrackerFilename, this.fileTracker);
    }

    private void writeFileTrackerData(String filetrackerFilename, FileTracker fileTracker) throws IOException {
        Path path = Paths.get(this.getReportDirectory().toString(), filetrackerFilename);
        Files.write(path, JacksonWrapper.serializeObject(fileTracker).getBytes(), new OpenOption[0]);
    }

    public void setBrowserAndVersion(ScreenshotContext screenshotContext, String browserAndVersion) {
        this.fileTracker.setBrowserAndVersion(screenshotContext, browserAndVersion);
    }

    public Map<BrowserStep, String> getBrowsers() {
        return this.fileTracker.browsers;
    }

    public void writeFileTrackerDataForScreenshotContextOnly(ScreenshotContext context) throws IOException {
        Path path = Paths.get(this.getScreenshotDirectory().toString(), FILE_SEPARATOR, String.valueOf(context.contextHash()), "metadata_" + context.step.name() + ".json");
        Files.write(path, JacksonWrapper.serializeObject(this.fileTracker.contexts.get(context.contextHash())).getBytes(), new OpenOption[0]);
    }

    public void mergeContextFileTrackersIntoFileTracker(Path directory, FilenameFilter filenameFilter) throws IOException {
        File dir = directory.toFile();
        File[] files = dir.listFiles(filenameFilter);
        assert (files != null);
        for (File file : files) {
            FileTracker part = JacksonWrapper.readFileTrackerFile(file);
            part.contexts.forEach((contextHash, screenshotContextFileTracker) -> this.fileTracker.contexts.merge((Integer)contextHash, (ScreenshotContextFileTracker)screenshotContextFileTracker, (existingContext, newContext) -> ScreenshotContextFileTracker.screenshotContextFileTrackerBuilder().withScreenshotContext(existingContext.screenshotContext).withScreenshots(existingContext.screenshots).addScreenshots(newContext.screenshots).build()));
            this.fileTracker.browsers.putAll(part.browsers);
        }
        this.writeFileTrackerData();
    }
}

