/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.file;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileUtils {
    public static void clearDirectory(String path) throws IOException {
        Path directory = Paths.get(path, new String[0]);
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(directory);){
            paths.forEach(file -> {
                try {
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        FileUtils.clearDirectory(file.toAbsolutePath().toString());
                    }
                    Files.delete(file);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    public static void deleteDirectory(Path path) throws IOException {
        FileUtils.clearDirectory(path.toString());
        Files.deleteIfExists(path);
    }

    public static void deleteDirectory(String path) throws IOException {
        FileUtils.deleteDirectory(Paths.get(path, new String[0]));
    }
}

