/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.file;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.otto.jlineup.browser.BrowserStep;
import de.otto.jlineup.browser.ScreenshotContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

@JsonDeserialize(builder=Builder.class)
public class ScreenshotContextFileTracker {
    public final ScreenshotContext screenshotContext;
    public final ConcurrentSkipListMap<Integer, Map<BrowserStep, String>> screenshots;

    ScreenshotContextFileTracker(ScreenshotContext screenshotContext) {
        this.screenshotContext = screenshotContext;
        this.screenshots = new ConcurrentSkipListMap();
    }

    private ScreenshotContextFileTracker(Builder builder) {
        this.screenshotContext = builder.screenshotContext;
        this.screenshots = builder.screenshots;
    }

    public static Builder screenshotContextFileTrackerBuilder() {
        return new Builder();
    }

    public static Builder copyOfBuilder(ScreenshotContextFileTracker copy) {
        Builder builder = new Builder();
        builder.screenshotContext = copy.getScreenshotContext();
        builder.screenshots = copy.getScreenshots();
        return builder;
    }

    public ScreenshotContext getScreenshotContext() {
        return this.screenshotContext;
    }

    public ConcurrentSkipListMap<Integer, Map<BrowserStep, String>> getScreenshots() {
        return this.screenshots;
    }

    void addScreenshot(ScreenshotContext screenshotContext, String path, int yPosition) {
        HashMap<BrowserStep, String> stepsToPathsMap = this.screenshots.get(yPosition);
        if (stepsToPathsMap == null) {
            HashMap<BrowserStep, String> mapToPut = new HashMap<BrowserStep, String>();
            stepsToPathsMap = this.screenshots.putIfAbsent(yPosition, mapToPut);
            if (stepsToPathsMap == null) {
                stepsToPathsMap = mapToPut;
            }
        }
        stepsToPathsMap.put(screenshotContext.step, path);
    }

    public String toString() {
        return "ScreenshotContextFileTracker{screenshotContext=" + String.valueOf(this.screenshotContext) + ", screenshots=" + String.valueOf(this.screenshots) + "}";
    }

    public static final class Builder {
        private ScreenshotContext screenshotContext;
        private ConcurrentSkipListMap<Integer, Map<BrowserStep, String>> screenshots;

        private Builder() {
        }

        public Builder withScreenshotContext(ScreenshotContext val) {
            this.screenshotContext = val;
            return this;
        }

        public Builder withScreenshots(ConcurrentSkipListMap<Integer, Map<BrowserStep, String>> val) {
            this.screenshots = val;
            return this;
        }

        public Builder addScreenshots(Map<Integer, Map<BrowserStep, String>> val) {
            if (this.screenshots == null) {
                this.screenshots = new ConcurrentSkipListMap();
            }
            for (Map.Entry<Integer, Map<BrowserStep, String>> integerMapEntry : val.entrySet()) {
                if (this.screenshots.containsKey(integerMapEntry.getKey())) {
                    this.screenshots.get(integerMapEntry.getKey()).putAll(integerMapEntry.getValue());
                    continue;
                }
                this.screenshots.put(integerMapEntry.getKey(), integerMapEntry.getValue());
            }
            return this;
        }

        public ScreenshotContextFileTracker build() {
            return new ScreenshotContextFileTracker(this);
        }
    }
}

