/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.image;

import de.otto.jlineup.image.AntiAliasingIgnoringComparator;
import de.otto.jlineup.image.LAB;
import de.otto.jlineup.image.PixelMatch;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int SAME_COLOR = Color.BLACK.getRGB();
    public static final int HIGHLIGHT_COLOR = Color.WHITE.getRGB();
    public static final int DIFFERENT_SIZE_COLOR = Color.GRAY.getRGB();
    public static final int LOOK_SAME_COLOR = Color.BLUE.getRGB();
    public static final int ANTI_ALIAS_DETECTED_COLOR = Color.GREEN.getRGB();
    public static final int PIXELMATCH_ANTI_ALIAS_DETECTED_COLOR = new Color(180, 255, 180).getRGB();

    public ImageComparisonResult compareImages(BufferedImage image1, BufferedImage image2, int viewportHeight, boolean ignoreAntiAliased, double maxAntiAliasColorDistance, boolean strictColorComparison, double maxColorDistance) {
        boolean hasAlphaChannel;
        if (image1 == null || image2 == null) {
            throw new NullPointerException("Can't compare null imagebuffers");
        }
        if (ImageService.bufferedImagesEqualQuick(image1, image2)) {
            return new ImageComparisonResult(null, 0.0, 0, 0.0);
        }
        boolean bl = hasAlphaChannel = image1.getAlphaRaster() != null && image2.getAlphaRaster() != null;
        if (!hasAlphaChannel) {
            LOG.debug("Add alpha channel to images to have 4 bits per pixel (makes pixelmatch work).");
            BufferedImage newImage1 = new BufferedImage(image1.getWidth(), image1.getHeight(), 6);
            BufferedImage newImage2 = new BufferedImage(image2.getWidth(), image2.getHeight(), 6);
            ColorConvertOp colorConvertOp = new ColorConvertOp(null);
            colorConvertOp.filter(image1, newImage1);
            colorConvertOp.filter(image2, newImage2);
            image1 = newImage1;
            image2 = newImage2;
        }
        int width1 = image1.getWidth();
        int height1 = image1.getHeight();
        int width2 = image2.getWidth();
        int height2 = image2.getHeight();
        int maxWidth = Math.max(image1.getWidth(), image2.getWidth());
        int maxHeight = Math.max(image1.getHeight(), image2.getHeight());
        int minWidth = Math.min(image1.getWidth(), image2.getWidth());
        int[] image1Pixels = image1.getRGB(0, 0, width1, height1, null, 0, width1);
        int[] image2Pixels = image2.getRGB(0, 0, width2, height2, null, 0, width2);
        int pixelCount1 = width1 * height1;
        int pixelCount2 = width2 * height2;
        int maxPixelCount = maxWidth * maxHeight;
        int minPixelCount = Math.min(pixelCount1, pixelCount2);
        int diffPixelCounter = 0;
        int checkedPixelCounter = 0;
        int antiAliasedDiffPixelCounter = 0;
        int lookSameDiffPixelCounter = 0;
        double maxDetectedColorDistance = 0.0;
        int[] differenceImagePixels = new int[maxPixelCount];
        int i1 = 0;
        int i2 = 0;
        int iD = 0;
        int x = 0;
        int y = 0;
        while (iD < maxPixelCount) {
            if (image1Pixels[i1] != image2Pixels[i2]) {
                boolean acceptableDifferenceDetected = false;
                ++checkedPixelCounter;
                if (!strictColorComparison) {
                    double colorDistance = ImageService.getColorDistance(image1Pixels[i1], image2Pixels[i2]);
                    maxDetectedColorDistance = Math.max(maxDetectedColorDistance, colorDistance);
                    if (colorDistance < maxColorDistance) {
                        Color color = Color.blue;
                        color = new Color(Math.min(255, color.getRed() + (int)(colorDistance * 255.0)), color.getGreen(), color.getBlue());
                        differenceImagePixels[iD] = color.getRGB();
                        LOG.debug("Same-looking pixels detected at pixel {}|{} with a max color distance of {}", new Object[]{x, y, maxColorDistance});
                        ++lookSameDiffPixelCounter;
                        acceptableDifferenceDetected = true;
                    }
                }
                if (!acceptableDifferenceDetected && ignoreAntiAliased && AntiAliasingIgnoringComparator.checkIsAntialiased(image1, image2, x, y, maxAntiAliasColorDistance)) {
                    differenceImagePixels[iD] = ANTI_ALIAS_DETECTED_COLOR;
                    LOG.debug("Anti-aliasing detected with looks-same at pixel {}|{} with a max anti alias color distance of {}", new Object[]{x, y, maxAntiAliasColorDistance});
                    ++antiAliasedDiffPixelCounter;
                    acceptableDifferenceDetected = true;
                }
                if (!acceptableDifferenceDetected && ignoreAntiAliased && width1 == width2 && height1 == height2 && PixelMatch.isAntiAliased(image1, x, y, width1, height1, image2)) {
                    differenceImagePixels[iD] = PIXELMATCH_ANTI_ALIAS_DETECTED_COLOR;
                    LOG.debug("Anti-aliasing detected with pixelmatch at pixel {}|{}", (Object)x, (Object)y);
                    ++antiAliasedDiffPixelCounter;
                    acceptableDifferenceDetected = true;
                }
                if (!acceptableDifferenceDetected) {
                    differenceImagePixels[iD] = HIGHLIGHT_COLOR;
                    ++diffPixelCounter;
                }
            } else {
                differenceImagePixels[iD] = SAME_COLOR;
            }
            ++i2;
            ++iD;
            if (++i1 % width1 == 0) {
                x = 0;
                ++y;
            } else {
                ++x;
            }
            if (width1 < width2 && i1 % minWidth == 0) {
                while (i2 % maxWidth != 0) {
                    ++i2;
                    differenceImagePixels[iD] = DIFFERENT_SIZE_COLOR;
                    ++diffPixelCounter;
                    ++iD;
                }
            } else if (width2 < width1 && i2 % minWidth == 0) {
                while (i1 % maxWidth != 0) {
                    ++i1;
                    differenceImagePixels[iD] = DIFFERENT_SIZE_COLOR;
                    ++diffPixelCounter;
                    ++iD;
                }
            }
            if (i1 != minPixelCount && i2 != minPixelCount) continue;
            while (iD < maxPixelCount) {
                if (iD % maxWidth < minWidth) {
                    differenceImagePixels[iD] = DIFFERENT_SIZE_COLOR;
                    ++diffPixelCounter;
                } else {
                    differenceImagePixels[iD] = SAME_COLOR;
                }
                ++iD;
            }
        }
        double difference = 1.0 * (double)diffPixelCounter / (double)Math.min(maxPixelCount, maxWidth * viewportHeight);
        BufferedImage out = new BufferedImage(maxWidth, maxHeight, 1);
        out.setRGB(0, 0, maxWidth, maxHeight, differenceImagePixels, 0, maxWidth);
        LOG.debug("checkedPixelCounter: {}, diffPixelCounter: {}, lookSameDiffPixelCounter: {}, antiAliasedDiffPixelCounter: {}, maxDetectedColorDistance: {}", new Object[]{checkedPixelCounter, diffPixelCounter, lookSameDiffPixelCounter, antiAliasedDiffPixelCounter, maxDetectedColorDistance});
        return new ImageComparisonResult(out, difference, lookSameDiffPixelCounter + antiAliasedDiffPixelCounter, maxDetectedColorDistance);
    }

    private static int[] getARGB(int pixel) {
        int alpha = pixel >> 24 & 0xFF;
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        return new int[]{alpha, red, green, blue};
    }

    static Color getColor(int pixel) {
        int[] argb = ImageService.getARGB(pixel);
        return new Color(argb[1], argb[2], argb[3], argb[0]);
    }

    public static boolean bufferedImagesEqual(BufferedImage image1, BufferedImage image2) {
        if (image1.getWidth() == image2.getWidth() && image1.getHeight() == image2.getHeight()) {
            for (int xPosition = 0; xPosition < image1.getWidth(); ++xPosition) {
                for (int yPosition = 0; yPosition < image1.getHeight(); ++yPosition) {
                    if (image1.getRGB(xPosition, yPosition) == image2.getRGB(xPosition, yPosition)) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    static double getColorDistance(int argbColor1, int argbColor2) {
        int[] argb1 = ImageService.getARGB(argbColor1);
        int[] argb2 = ImageService.getARGB(argbColor2);
        LAB lab1 = LAB.fromRGB(argb1[1], argb1[2], argb1[3], 0.0);
        LAB lab2 = LAB.fromRGB(argb2[1], argb2[2], argb2[3], 0.0);
        return Math.abs(LAB.ciede2000(lab1, lab2));
    }

    public static boolean bufferedImagesEqualQuick(BufferedImage image1, BufferedImage image2) {
        DataBuffer dataBuffer1 = image1.getRaster().getDataBuffer();
        DataBuffer dataBuffer2 = image2.getRaster().getDataBuffer();
        if (dataBuffer1 instanceof DataBufferByte && dataBuffer2 instanceof DataBufferByte) {
            DataBufferByte dataBufferBytes1 = (DataBufferByte)dataBuffer1;
            DataBufferByte dataBufferBytes2 = (DataBufferByte)dataBuffer2;
            for (int bank = 0; bank < dataBufferBytes1.getNumBanks(); ++bank) {
                byte[] bytes2;
                byte[] bytes1 = dataBufferBytes1.getData(bank);
                if (Arrays.equals(bytes1, bytes2 = dataBufferBytes2.getData(bank))) continue;
                return false;
            }
        } else if (dataBuffer1 instanceof DataBufferInt && dataBuffer2 instanceof DataBufferInt) {
            DataBufferInt dataBufferInt1 = (DataBufferInt)dataBuffer1;
            DataBufferInt dataBufferInt2 = (DataBufferInt)dataBuffer2;
            for (int bank = 0; bank < dataBufferInt1.getNumBanks(); ++bank) {
                int[] ints2;
                int[] ints1 = dataBufferInt1.getData(bank);
                if (Arrays.equals(ints1, ints2 = dataBufferInt2.getData(bank))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static class ImageComparisonResult {
        private final BufferedImage differenceImage;
        private final double difference;
        private final int acceptedDifferentPixels;
        private final double maxDetectedColorDistance;

        public ImageComparisonResult(BufferedImage differenceImage, double difference, int acceptedDifferentPixels, double maxDetectedColorDistance) {
            this.differenceImage = differenceImage;
            this.difference = difference;
            this.acceptedDifferentPixels = acceptedDifferentPixels;
            this.maxDetectedColorDistance = maxDetectedColorDistance;
        }

        public Optional<BufferedImage> getDifferenceImage() {
            return Optional.ofNullable(this.differenceImage);
        }

        public double getDifference() {
            return this.difference;
        }

        public int getAcceptedDifferentPixels() {
            return this.acceptedDifferentPixels;
        }

        public double getMaxDetectedColorDistance() {
            return this.maxDetectedColorDistance;
        }
    }
}

