/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.image;

import java.awt.image.BufferedImage;

public class NtscYiqColorDifferenceCalculator {
    public static double colorDelta(BufferedImage img1, BufferedImage img2, int xPos, int yPos, boolean yOnly) {
        int pixel1 = img1.getRGB(xPos, yPos);
        int pixel2 = img2.getRGB(xPos, yPos);
        return NtscYiqColorDifferenceCalculator.colorDelta(pixel1, pixel2, yOnly);
    }

    public static double colorDelta(int argb1, int argb2, boolean yOnly) {
        int a1 = argb1 >> 24 & 0xFF;
        int r1 = argb1 >> 16 & 0xFF;
        int g1 = argb1 >> 8 & 0xFF;
        int b1 = argb1 & 0xFF;
        int a2 = argb2 >> 24 & 0xFF;
        int r2 = argb2 >> 16 & 0xFF;
        int g2 = argb2 >> 8 & 0xFF;
        int b2 = argb2 & 0xFF;
        if (a1 == a2 && r1 == r2 && g1 == g2 && b1 == b2) {
            return 0.0;
        }
        if (a1 < 255) {
            r1 = NtscYiqColorDifferenceCalculator.blend(r1, a1 /= 255);
            g1 = NtscYiqColorDifferenceCalculator.blend(g1, a1);
            b1 = NtscYiqColorDifferenceCalculator.blend(b1, a1);
        }
        if (a2 < 255) {
            r2 = NtscYiqColorDifferenceCalculator.blend(r2, a2 /= 255);
            g2 = NtscYiqColorDifferenceCalculator.blend(g2, a2);
            b2 = NtscYiqColorDifferenceCalculator.blend(b2, a2);
        }
        double y1 = NtscYiqColorDifferenceCalculator.rgb2y(r1, g1, b1);
        double y2 = NtscYiqColorDifferenceCalculator.rgb2y(r2, g2, b2);
        double y = y1 - y2;
        if (yOnly) {
            return y;
        }
        double i = NtscYiqColorDifferenceCalculator.rgb2i(r1, g1, b1) - NtscYiqColorDifferenceCalculator.rgb2i(r2, g2, b2);
        double q = NtscYiqColorDifferenceCalculator.rgb2q(r1, g1, b1) - NtscYiqColorDifferenceCalculator.rgb2q(r2, g2, b2);
        double delta = 0.5053 * y * y + 0.299 * i * i + 0.1957 * q * q;
        return y1 > y2 ? -delta : delta;
    }

    private static double rgb2y(int r, int g, int b) {
        return (double)r * 0.29889531 + (double)g * 0.58662247 + (double)b * 0.11448223;
    }

    private static double rgb2i(int r, int g, int b) {
        return (double)r * 0.59597799 - (double)g * 0.2741761 - (double)b * 0.32180189;
    }

    private static double rgb2q(int r, int g, int b) {
        return (double)r * 0.21147017 - (double)g * 0.52261711 + (double)b * 0.31114694;
    }

    private static int blend(int c, int a) {
        return 255 + (c - 255) * a;
    }
}

