/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PixelMatch {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static boolean isAntiAliased(BufferedImage bufferedImage, int x1, int y1, int width, int height, BufferedImage bufferedImage2) {
        boolean hasImage2AlphaChannel;
        boolean hasAlphaChannel = bufferedImage.getAlphaRaster() != null;
        boolean bl = hasImage2AlphaChannel = bufferedImage2.getAlphaRaster() != null;
        if (!hasAlphaChannel || !hasImage2AlphaChannel) {
            throw new RuntimeException("Image must have an alpha channel");
        }
        byte[] img1 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        byte[] img2 = ((DataBufferByte)bufferedImage2.getRaster().getDataBuffer()).getData();
        if (img1.length != width * height * 4) {
            LOG.debug("Image 1 data size does not match width/height.");
            return false;
        }
        if (img2.length != width * height * 4) {
            LOG.debug("Image 2 data size does not match width/height.");
            return false;
        }
        int x0 = Math.max(x1 - 1, 0);
        int y0 = Math.max(y1 - 1, 0);
        int x2 = Math.min(x1 + 1, width - 1);
        int y2 = Math.min(y1 + 1, height - 1);
        int pos = (y1 * width + x1) * 4;
        int zeroes = x1 == x0 || x1 == x2 || y1 == y0 || y1 == y2 ? 1 : 0;
        double min = 0.0;
        double max = 0.0;
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        for (int x = x0; x <= x2; ++x) {
            for (int y = y0; y <= y2; ++y) {
                if (x == x1 && y == y1) continue;
                double delta = PixelMatch.colorDelta(img1, img1, pos, (y * width + x) * 4, true);
                if (delta == 0.0) {
                    if (++zeroes <= 2) continue;
                    return false;
                }
                if (delta < min) {
                    min = delta;
                    minX = x;
                    minY = y;
                    continue;
                }
                if (!(delta > max)) continue;
                max = delta;
                maxX = x;
                maxY = y;
            }
        }
        if (min == 0.0 || max == 0.0) {
            return false;
        }
        return PixelMatch.hasManySiblings(img1, minX, minY, width, height) && PixelMatch.hasManySiblings(img2, minX, minY, width, height) || PixelMatch.hasManySiblings(img1, maxX, maxY, width, height) && PixelMatch.hasManySiblings(img2, maxX, maxY, width, height);
    }

    static boolean hasManySiblings(byte[] img, int x1, int y1, int width, int height) {
        int x0 = Math.max(x1 - 1, 0);
        int y0 = Math.max(y1 - 1, 0);
        int x2 = Math.min(x1 + 1, width - 1);
        int y2 = Math.min(y1 + 1, height - 1);
        int pos = (y1 * width + x1) * 4;
        int zeroes = x1 == x0 || x1 == x2 || y1 == y0 || y1 == y2 ? 1 : 0;
        for (int x = x0; x <= x2; ++x) {
            for (int y = y0; y <= y2; ++y) {
                if (x == x1 && y == y1) continue;
                int pos2 = (y * width + x) * 4;
                if (img[pos] == img[pos2] && img[pos + 1] == img[pos2 + 1] && img[pos + 2] == img[pos2 + 2] && img[pos + 3] == img[pos2 + 3]) {
                    ++zeroes;
                }
                if (zeroes <= 2) continue;
                return true;
            }
        }
        return false;
    }

    static double colorDelta(byte[] img1, byte[] img2, int k, int m, boolean yOnly) {
        double r1 = img1[k + 0] + 128;
        double g1 = img1[k + 1] + 128;
        double b1 = img1[k + 2] + 128;
        double a1 = img1[k + 3] + 128;
        double r2 = img2[m + 0] + 128;
        double g2 = img2[m + 1] + 128;
        double b2 = img2[m + 2] + 128;
        double a2 = img2[m + 3] + 128;
        if (a1 == a2 && r1 == r2 && g1 == g2 && b1 == b2) {
            return 0.0;
        }
        if (a1 < 255.0) {
            r1 = PixelMatch.blend(r1, a1 /= 255.0);
            g1 = PixelMatch.blend(g1, a1);
            b1 = PixelMatch.blend(b1, a1);
        }
        if (a2 < 255.0) {
            r2 = PixelMatch.blend(r2, a2 /= 255.0);
            g2 = PixelMatch.blend(g2, a2);
            b2 = PixelMatch.blend(b2, a2);
        }
        double y1 = PixelMatch.rgb2y(r1, g1, b1);
        double y2 = PixelMatch.rgb2y(r2, g2, b2);
        double y = y1 - y2;
        if (yOnly) {
            return y;
        }
        double i = PixelMatch.rgb2i(r1, g1, b1) - PixelMatch.rgb2i(r2, g2, b2);
        double q = PixelMatch.rgb2q(r1, g1, b1) - PixelMatch.rgb2q(r2, g2, b2);
        double delta = 0.5053 * y * y + 0.299 * i * i + 0.1957 * q * q;
        return y1 > y2 ? -delta : delta;
    }

    static double rgb2y(double r, double g, double b) {
        return r * 0.29889531 + g * 0.58662247 + b * 0.11448223;
    }

    static double rgb2i(double r, double g, double b) {
        return r * 0.59597799 - g * 0.2741761 - b * 0.32180189;
    }

    static double rgb2q(double r, double g, double b) {
        return r * 0.21147017 - g * 0.52261711 + b * 0.31114694;
    }

    static double blend(double c, double a) {
        return 255.0 + (c - 255.0) * a;
    }
}

