/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.report;

import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.report.Report;
import de.otto.jlineup.report.ScreenshotComparisonResult;
import de.otto.jlineup.report.Summary;
import de.otto.jlineup.report.UrlReport;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.stream.Collectors;

public class ReportGenerator {
    public Report generateReport(Map<String, List<ScreenshotComparisonResult>> screenshotComparisonResultLists, JobConfig config) {
        List<ScreenshotComparisonResult> resultList = screenshotComparisonResultLists.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Summary summary = this.getSummary(resultList);
        HashMap<String, UrlReport> urlReports = new HashMap<String, UrlReport>();
        for (Map.Entry<String, List<ScreenshotComparisonResult>> result : screenshotComparisonResultLists.entrySet()) {
            Summary localSummary = this.getSummary(result.getValue());
            UrlReport urlReport = new UrlReport(result.getValue(), localSummary);
            urlReports.put(result.getKey(), urlReport);
        }
        return new Report(summary, urlReports, config);
    }

    private Summary getSummary(List<ScreenshotComparisonResult> resultList) {
        double differenceSum = resultList.stream().mapToDouble(scr -> scr.difference).sum();
        OptionalDouble differenceMax = resultList.stream().mapToDouble(scr -> scr.difference).max();
        int acceptedDifferentPixelsSum = resultList.stream().mapToInt(scr -> scr.acceptedDifferentPixels).sum();
        return new Summary(differenceSum > 0.0, differenceSum, differenceMax.orElseGet(() -> 0.0), acceptedDifferentPixelsSum);
    }
}

