/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.web;

import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.exceptions.ValidationError;
import de.otto.jlineup.service.BrowserNotInstalledException;
import de.otto.jlineup.service.InvalidRunStateException;
import de.otto.jlineup.service.JLineupService;
import de.otto.jlineup.service.RunNotFoundException;
import de.otto.jlineup.web.JLineupRunStatus;
import de.otto.jlineup.web.RunBeforeResponse;
import java.net.URI;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JLineupController {
    private final JLineupService jLineupService;

    @Autowired
    public JLineupController(JLineupService jLineupService) {
        this.jLineupService = jLineupService;
    }

    @GetMapping(value={"/"})
    public String getHello() {
        return "JLineup is great!";
    }

    @PostMapping(value={"/runs"})
    public ResponseEntity<RunBeforeResponse> runBefore(@RequestBody JobConfig jobConfig, HttpServletRequest request) throws Exception {
        String id = this.jLineupService.startBeforeRun(jobConfig).getId();
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(URI.create(request.getContextPath() + "/runs/" + id));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().headers(headers)).body((Object)new RunBeforeResponse(id));
    }

    @PostMapping(value={"/runs/{runId}"})
    public ResponseEntity<Void> runAfter(@PathVariable String runId, HttpServletRequest request) throws Exception {
        this.jLineupService.startAfterRun(runId);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(URI.create(request.getContextPath() + "/runs/" + runId));
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.ACCEPTED);
    }

    @GetMapping(value={"/runs/{runId}"})
    public ResponseEntity<JLineupRunStatus> getRun(@PathVariable String runId) {
        Optional run = this.jLineupService.getRun(runId);
        return run.map(jLineupRunStatus -> new ResponseEntity(jLineupRunStatus, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @ExceptionHandler(value={RunNotFoundException.class})
    public ResponseEntity<String> exceptionHandler(RunNotFoundException exception) {
        return new ResponseEntity((Object)String.format("Run with id '%s' was not found", exception.getId()), HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={InvalidRunStateException.class})
    public ResponseEntity<String> exceptionHandler(InvalidRunStateException exception) {
        return new ResponseEntity((Object)String.format("Run with id '%s' has wrong state. was %s but expected %s", exception.getId(), exception.getCurrentState(), exception.getExpectedState()), HttpStatus.PRECONDITION_FAILED);
    }

    @ExceptionHandler(value={BrowserNotInstalledException.class})
    public ResponseEntity<String> exceptionHandler(BrowserNotInstalledException exception) {
        return new ResponseEntity((Object)String.format("Browser %s is not installed or not configured on server side.", exception.getDesiredBrowser().name()), HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={InvalidDefinitionException.class})
    public ResponseEntity<String> exceptionHandler(InvalidDefinitionException exception) {
        return new ResponseEntity((Object)exception.getCause().getMessage(), HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={ValidationError.class})
    public ResponseEntity<String> exceptionHandler(ValidationError exception) {
        return new ResponseEntity((Object)exception.getMessage(), HttpStatus.UNPROCESSABLE_ENTITY);
    }
}

