/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.service;

import com.google.common.collect.ImmutableList;
import de.otto.jlineup.JLineupRunner;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.service.InvalidRunStateException;
import de.otto.jlineup.service.RunNotFoundException;
import de.otto.jlineup.web.JLineupRunStatus;
import de.otto.jlineup.web.JLineupRunnerFactory;
import de.otto.jlineup.web.State;
import de.otto.jlineup.web.configuration.JLineupWebProperties;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JLineupService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ConcurrentHashMap<String, JLineupRunStatus> runs = new ConcurrentHashMap();
    private final ExecutorService executorService;
    private final AtomicInteger runningJobs = new AtomicInteger();
    private final JLineupRunnerFactory jLineupRunnerFactory;

    @Autowired
    public JLineupService(JLineupRunnerFactory jLineupRunnerFactory, JLineupWebProperties jLineupWebProperties) {
        this.jLineupRunnerFactory = jLineupRunnerFactory;
        this.executorService = Executors.newFixedThreadPool(jLineupWebProperties.getMaxParallelJobs());
    }

    public synchronized JLineupRunStatus startBeforeRun(JobConfig jobConfig) throws Exception {
        String runId = UUID.randomUUID().toString();
        JLineupRunStatus beforeStatus = JLineupRunStatus.runStatusBuilder().withId(runId).withJobConfig(jobConfig).withState(State.BEFORE_PENDING).withStartTime(Instant.now()).build();
        JLineupRunner jLineupRunner = this.jLineupRunnerFactory.createBeforeRun(runId, jobConfig);
        this.runs.put(runId, beforeStatus);
        this.runningJobs.incrementAndGet();
        CompletionStage state = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            this.changeState(runId, State.BEFORE_RUNNING);
            jLineupRunner.run();
            return State.BEFORE_DONE;
        }, this.executorService).exceptionally(ex -> State.ERROR)).thenApply(st -> {
            this.changeState(runId, st);
            this.runningJobs.decrementAndGet();
            return st;
        });
        return JLineupRunStatus.copyOfRunStatusBuilder((JLineupRunStatus)beforeStatus).withCurrentJobStepFuture((CompletableFuture)state).build();
    }

    public synchronized JLineupRunStatus startAfterRun(String runId) throws Exception {
        Optional run = this.getRun(runId);
        if (!run.isPresent()) {
            throw new RunNotFoundException(runId);
        }
        JLineupRunStatus beforeStatus = (JLineupRunStatus)run.get();
        if (beforeStatus.getState() != State.BEFORE_DONE) {
            throw new InvalidRunStateException(beforeStatus.getId(), beforeStatus.getState(), State.BEFORE_DONE);
        }
        JLineupRunner jLineupRunner = this.jLineupRunnerFactory.createAfterRun(runId, beforeStatus.getJobConfig());
        JLineupRunStatus afterStatus = this.changeState(runId, State.AFTER_PENDING);
        this.runningJobs.incrementAndGet();
        CompletionStage state = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            this.changeState(runId, State.AFTER_RUNNING);
            boolean runSucceeded = jLineupRunner.run();
            if (runSucceeded) {
                return State.FINISHED_WITHOUT_DIFFERENCES;
            }
            return State.FINISHED_WITH_DIFFERENCES;
        }, this.executorService).exceptionally(ex -> {
            LOG.error("Error in after runStep.", ex);
            return State.ERROR;
        })).thenApply(st -> {
            this.changeState(runId, st);
            this.runningJobs.decrementAndGet();
            return st;
        });
        return JLineupRunStatus.copyOfRunStatusBuilder((JLineupRunStatus)afterStatus).withCurrentJobStepFuture((CompletableFuture)state).build();
    }

    private JLineupRunStatus changeState(String runId, State state) {
        JLineupRunStatus runStatus = (JLineupRunStatus)this.runs.get(runId);
        JLineupRunStatus.Builder runStatusBuilder = JLineupRunStatus.copyOfRunStatusBuilder((JLineupRunStatus)runStatus).withState(state);
        if (state == State.BEFORE_RUNNING) {
            runStatusBuilder.withReports(JLineupRunStatus.Reports.reportsBuilder().withLogUrl("/reports/report-" + runId + "/jlineup.log").build());
        }
        if (state == State.ERROR || state == State.DEAD) {
            runStatusBuilder.withEndTime(Instant.now());
        }
        if (state == State.FINISHED_WITH_DIFFERENCES || state == State.FINISHED_WITHOUT_DIFFERENCES) {
            runStatusBuilder.withEndTime(Instant.now());
            runStatusBuilder.withReports(JLineupRunStatus.Reports.reportsBuilder().withHtmlUrl("/reports/report-" + runId + "/report.html").withJsonUrl("/reports/report-" + runId + "/report.json").withLogUrl("/reports/report-" + runId + "/jlineup.log").build());
        }
        JLineupRunStatus newStatus = runStatusBuilder.build();
        this.runs.put(runId, newStatus);
        return newStatus;
    }

    public Optional<JLineupRunStatus> getRun(String id) {
        return Optional.ofNullable(this.runs.get(id));
    }

    public List<JLineupRunStatus> getRunStatus() {
        return ImmutableList.copyOf(this.runs.values());
    }
}

