/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.web;

import de.otto.jlineup.JLineupRunner;
import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.RunStep;
import de.otto.jlineup.config.UrlConfig;
import de.otto.jlineup.service.BrowserNotInstalledException;
import de.otto.jlineup.web.configuration.JLineupWebProperties;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JLineupRunnerFactory {
    private final JLineupWebProperties properties;

    @Autowired
    public JLineupRunnerFactory(JLineupWebProperties properties) {
        this.properties = properties;
    }

    public JLineupRunner createBeforeRun(String id, JobConfig jobConfig) throws Exception {
        return this.createRun(id, jobConfig, RunStep.before);
    }

    public JLineupRunner createAfterRun(String id, JobConfig jobConfig) throws Exception {
        return this.createRun(id, jobConfig, RunStep.after);
    }

    private JLineupRunner createRun(String id, JobConfig jobConfig, RunStep step) throws Exception {
        JobConfig webJobConfig = this.sanitizeJobConfig(jobConfig);
        if (webJobConfig.approvalLink != null && webJobConfig.approvalLink.contains("{id}")) {
            webJobConfig = JobConfig.copyOfBuilder((JobConfig)webJobConfig).withApprovalLink(webJobConfig.approvalLink.replace("{id}", id)).build();
        }
        return new JLineupRunner(webJobConfig, RunStepConfig.runStepConfigBuilder().withWorkingDirectory(this.properties.getWorkingDirectory()).withScreenshotsDirectory(this.properties.getScreenshotsDirectory().replace("{id}", id)).withReportDirectory(this.properties.getReportDirectory().replace("{id}", id)).withChromeParameters(this.properties.getChromeLaunchParameters().stream().map(param -> param.replace("{id}", id)).map(param -> param.startsWith("--user-data-dir") ? param + "/{random-folder}" : param).collect(Collectors.toList())).withFirefoxParameters(this.properties.getFirefoxLaunchParameters().stream().map(param -> param.replace("{id}", id)).map(param -> param.startsWith("-profile ") || param.startsWith("-P ") ? param + "/{random-folder}" : param).collect(Collectors.toList())).withCleanupProfile(this.properties.isCleanupProfile()).withStep(step).build());
    }

    JobConfig sanitizeJobConfig(JobConfig jobConfig) throws BrowserNotInstalledException, IllegalArgumentException {
        if (!this.properties.getInstalledBrowsers().contains(jobConfig.browser)) {
            throw new BrowserNotInstalledException(jobConfig.browser);
        }
        if (!this.properties.getAllowedUrlPrefixes().isEmpty()) {
            for (UrlConfig urlConfig : jobConfig.urls.values()) {
                if (this.properties.getAllowedUrlPrefixes().stream().noneMatch(urlConfig.getUrl()::startsWith)) {
                    throw new IllegalArgumentException("URL " + urlConfig.url + " is not allowed. Allowed prefixes are: " + String.valueOf(this.properties.getAllowedUrlPrefixes()));
                }
                if (urlConfig.javaScript == null) continue;
                String javaScript = urlConfig.javaScript;
                try {
                    String decodedJavaScript;
                    while (!(decodedJavaScript = URLDecoder.decode(javaScript, "UTF-8")).equals(javaScript)) {
                        javaScript = decodedJavaScript;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("JavaScript code must be UTF-8 encoded.");
                }
                if (!javaScript.contains("http://") && !javaScript.contains("https://")) continue;
                List<String> urls = JLineupRunnerFactory.findSubstringsStartingWithSearchString(javaScript, "http://");
                urls.addAll(JLineupRunnerFactory.findSubstringsStartingWithSearchString(javaScript, "https://"));
                for (String url : urls) {
                    if (!this.properties.getAllowedUrlPrefixes().stream().noneMatch(url::startsWith)) continue;
                    throw new IllegalArgumentException("URL " + url + " is not allowed. Allowed prefixes are: " + String.valueOf(this.properties.getAllowedUrlPrefixes()));
                }
            }
        }
        return JobConfig.copyOfBuilder((JobConfig)jobConfig).withThreads(this.calculateNumberOfThreads(jobConfig)).withDebug(false).withLogToFile(false).withReportFormat(2).build();
    }

    private int calculateNumberOfThreads(JobConfig jobConfig) {
        return jobConfig.threads == 0 ? this.properties.getMaxThreadsPerJob() : Math.min(jobConfig.threads, this.properties.getMaxThreadsPerJob());
    }

    private static List<String> findSubstringsStartingWithSearchString(String input, String searchString) {
        ArrayList<String> substrings = new ArrayList<String>();
        for (int index = 0; index < input.length() && (index = input.indexOf(searchString, index)) != -1; index += searchString.length()) {
            int endIndex = input.indexOf(32, index);
            if (endIndex == -1) {
                endIndex = input.length();
            }
            substrings.add(input.substring(index, endIndex));
        }
        return substrings;
    }
}

