/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.web.configuration;

import de.otto.jlineup.browser.Browser;
import de.otto.jlineup.web.configuration.JLineupWebLambdaProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="jlineup")
public class JLineupWebProperties {
    public static final int DEFAULT_MAX_PARALLEL_JOBS = 1;
    public static final int DEFAULT_MAX_THREADS_PER_JOB = 4;
    public static final int DEFAULT_MAX_PERSISTED_RUNS = 100;
    private String workingDirectory = "/tmp/jlineup/";
    private String screenshotsDirectory = "report-{id}";
    private String reportDirectory = "report-{id}";
    private boolean cleanupProfile = true;
    private int maxParallelJobs = 1;
    private int maxThreadsPerJob = 4;
    private List<String> chromeLaunchParameters = Collections.emptyList();
    private List<String> firefoxLaunchParameters = Collections.emptyList();
    private List<Browser.Type> installedBrowsers = Arrays.asList(Browser.Type.CHROME_HEADLESS, Browser.Type.FIREFOX_HEADLESS);
    private List<String> allowedUrlPrefixes = Collections.emptyList();
    private int maxPersistedRuns = 100;
    private JLineupWebLambdaProperties lambda = new JLineupWebLambdaProperties();

    public String toString() {
        return "JLineupWebProperties{workingDirectory='" + this.workingDirectory + "', screenshotsDirectory='" + this.screenshotsDirectory + "', reportDirectory='" + this.reportDirectory + "', cleanupProfile=" + this.cleanupProfile + ", maxParallelJobs=" + this.maxParallelJobs + ", maxThreadsPerJob=" + this.maxThreadsPerJob + ", chromeLaunchParameters=" + String.valueOf(this.chromeLaunchParameters) + ", firefoxLaunchParameters=" + String.valueOf(this.firefoxLaunchParameters) + ", installedBrowsers=" + String.valueOf(this.installedBrowsers) + ", allowedUrlPrefixes=" + String.valueOf(this.allowedUrlPrefixes) + ", maxPersistedRuns=" + this.maxPersistedRuns + ", lambda=" + String.valueOf(this.lambda) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JLineupWebProperties that = (JLineupWebProperties)o;
        return this.cleanupProfile == that.cleanupProfile && this.maxParallelJobs == that.maxParallelJobs && this.maxThreadsPerJob == that.maxThreadsPerJob && this.maxPersistedRuns == that.maxPersistedRuns && Objects.equals(this.workingDirectory, that.workingDirectory) && Objects.equals(this.screenshotsDirectory, that.screenshotsDirectory) && Objects.equals(this.reportDirectory, that.reportDirectory) && Objects.equals(this.chromeLaunchParameters, that.chromeLaunchParameters) && Objects.equals(this.firefoxLaunchParameters, that.firefoxLaunchParameters) && Objects.equals(this.installedBrowsers, that.installedBrowsers) && Objects.equals(this.allowedUrlPrefixes, that.allowedUrlPrefixes) && Objects.equals(this.lambda, that.lambda);
    }

    public int hashCode() {
        return Objects.hash(this.workingDirectory, this.screenshotsDirectory, this.reportDirectory, this.cleanupProfile, this.maxParallelJobs, this.maxThreadsPerJob, this.chromeLaunchParameters, this.firefoxLaunchParameters, this.installedBrowsers, this.allowedUrlPrefixes, this.maxPersistedRuns, this.lambda);
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getScreenshotsDirectory() {
        return this.screenshotsDirectory;
    }

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setScreenshotsDirectory(String screenshotsDirectory) {
        this.screenshotsDirectory = screenshotsDirectory;
    }

    public void setReportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    public int getMaxParallelJobs() {
        return this.maxParallelJobs;
    }

    public void setMaxParallelJobs(int maxParallelJobs) {
        this.maxParallelJobs = maxParallelJobs;
    }

    public List<Browser.Type> getInstalledBrowsers() {
        return this.installedBrowsers;
    }

    public void setInstalledBrowsers(List<Browser.Type> installedBrowsers) {
        this.installedBrowsers = installedBrowsers;
    }

    public int getMaxThreadsPerJob() {
        return this.maxThreadsPerJob;
    }

    public void setMaxThreadsPerJob(int maxThreadsPerJob) {
        this.maxThreadsPerJob = maxThreadsPerJob;
    }

    public List<String> getChromeLaunchParameters() {
        return this.chromeLaunchParameters;
    }

    public List<String> getFirefoxLaunchParameters() {
        return this.firefoxLaunchParameters;
    }

    public void setFirefoxLaunchParameters(List<String> firefoxLaunchParameters) {
        this.firefoxLaunchParameters = firefoxLaunchParameters;
    }

    public void setChromeLaunchParameters(List<String> chromeLaunchParameters) {
        this.chromeLaunchParameters = chromeLaunchParameters;
    }

    public boolean isCleanupProfile() {
        return this.cleanupProfile;
    }

    public void setCleanupProfile(boolean cleanupProfile) {
        this.cleanupProfile = cleanupProfile;
    }

    public JLineupWebLambdaProperties getLambda() {
        return this.lambda;
    }

    public void setLambda(JLineupWebLambdaProperties lambda) {
        this.lambda = lambda;
    }

    public int getMaxPersistedRuns() {
        return this.maxPersistedRuns;
    }

    public void setMaxPersistedRuns(int maxPersistedRuns) {
        this.maxPersistedRuns = maxPersistedRuns;
    }

    public List<String> getAllowedUrlPrefixes() {
        return this.allowedUrlPrefixes;
    }

    public void setAllowedUrlPrefixes(List<String> allowedUrlPrefixes) {
        this.allowedUrlPrefixes = allowedUrlPrefixes;
    }
}

