/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.web;

import de.otto.jlineup.service.JLineupService;
import de.otto.jlineup.web.JLineupRunStatus;
import de.otto.jlineup.web.State;
import de.otto.jlineup.web.configuration.JLineupWebProperties;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class ReportController {
    private JLineupService jLineupService;
    private JLineupWebProperties jLineupWebProperties;
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd kk:mm").withZone(ZoneId.systemDefault());

    @Autowired
    public ReportController(JLineupService jLineupService, JLineupWebProperties jLineupWebProperties) {
        this.jLineupService = jLineupService;
        this.jLineupWebProperties = jLineupWebProperties;
    }

    @RequestMapping(value={"${edison.application.management.base-path:/internal}/reports"}, produces={"text/html"}, method={RequestMethod.GET})
    public ModelAndView getReports() {
        return new ModelAndView("reports"){
            {
                this.addObject("reportList", ReportController.this.jLineupService.getRunStatus().stream().sorted(Comparator.comparing(JLineupRunStatus::getStartTime).reversed()).map(Report::new).limit(ReportController.this.jLineupWebProperties.getMaxPersistedRuns()).collect(Collectors.toList()));
            }
        };
    }

    private static String getDurationAsString(JLineupRunStatus status) {
        AtomicLong durationMillis = new AtomicLong();
        Instant startTime = status.getStartTime();
        status.getPauseTime().ifPresent(pauseTime -> durationMillis.addAndGet(Duration.between(startTime, pauseTime).toMillis()));
        status.getEndTime().ifPresent(endTime -> durationMillis.addAndGet(Duration.between(status.getResumeTime().orElse((Instant)endTime), endTime).toMillis()));
        if (status.getState() == State.BEFORE_RUNNING) {
            durationMillis.addAndGet(Duration.between(startTime, Instant.now()).toMillis());
        } else if (status.getState() == State.AFTER_RUNNING) {
            durationMillis.addAndGet(Duration.between(status.getResumeTime().orElse(Instant.now()), Instant.now()).toMillis());
        }
        Duration duration = Duration.ofMillis(durationMillis.get());
        long HH = duration.toHours();
        long MM = duration.toMinutesPart();
        long SS = duration.toSecondsPart();
        return String.format("%02d:%02d:%02d", HH, MM, SS);
    }

    private static String formatTime(Instant time) {
        return dateTimeFormatter.format(time);
    }

    public static class Report {
        private String id;
        private String name;
        private String reportUrl;
        private String logUrl;
        private String duration;
        private String startTime;
        private List<String> urls;
        private State state;

        public Report(JLineupRunStatus lineupRunStatus) {
            this.id = lineupRunStatus.getId();
            this.name = lineupRunStatus.getJobConfig().name;
            this.urls = lineupRunStatus.getUrls();
            this.reportUrl = lineupRunStatus.getReports() != null ? lineupRunStatus.getReports().getHtmlUrlFromCurrentContext() : null;
            this.logUrl = lineupRunStatus.getReports() != null ? lineupRunStatus.getReports().getLogUrlFromCurrentContext() : null;
            this.duration = ReportController.getDurationAsString(lineupRunStatus);
            this.startTime = ReportController.formatTime(lineupRunStatus.getStartTime());
            this.state = lineupRunStatus.getState();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getReportUrl() {
            return this.reportUrl;
        }

        public void setReportUrl(String reportUrl) {
            this.reportUrl = reportUrl;
        }

        public String getDuration() {
            return this.duration;
        }

        public void setDuration(String duration) {
            this.duration = duration;
        }

        public String getState() {
            return this.state.getHumanReadableName();
        }

        public void setState(State state) {
            this.state = state;
        }

        public String getLogUrl() {
            return this.logUrl;
        }

        public void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public List<String> getUrls() {
            return this.urls;
        }

        public void setUrls(List<String> urls) {
            this.urls = urls;
        }

        public String toString() {
            return "Report{id='" + this.id + "', name='" + this.name + "', reportUrl='" + this.reportUrl + "', logUrl='" + this.logUrl + "', duration='" + this.duration + "', startTime='" + this.startTime + "', urls=" + String.valueOf(this.urls) + ", state=" + String.valueOf((Object)this.state) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Report report = (Report)o;
            return Objects.equals(this.id, report.id) && Objects.equals(this.name, report.name) && Objects.equals(this.reportUrl, report.reportUrl) && Objects.equals(this.logUrl, report.logUrl) && Objects.equals(this.duration, report.duration) && Objects.equals(this.startTime, report.startTime) && Objects.equals(this.urls, report.urls) && this.state == report.state;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.name, this.reportUrl, this.logUrl, this.duration, this.startTime, this.urls, this.state});
        }

        public String getName() {
            return this.name;
        }
    }
}

