/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.web;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.UrlConfig;
import de.otto.jlineup.web.State;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@JsonNaming(value=PropertyNamingStrategy.class)
@JsonDeserialize(builder=Builder.class)
public class JLineupRunStatus {
    private final String id;
    private final State state;
    private final Instant startTime;
    private final Instant pauseTime;
    private final Instant resumeTime;
    private final Instant endTime;
    private final Reports reports;
    @JsonIgnore
    private final CompletableFuture<State> currentJobStepFuture;
    private final JobConfig jobConfig;

    private JLineupRunStatus(Builder builder) {
        this.id = builder.id;
        this.jobConfig = builder.jobConfig;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.pauseTime = builder.pauseTime;
        this.resumeTime = builder.resumeTime;
        this.endTime = builder.endTime;
        this.currentJobStepFuture = builder.currentJobStepFuture;
        this.reports = builder.reports;
    }

    public String getId() {
        return this.id;
    }

    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    public State getState() {
        return this.state;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Optional<Instant> getEndTime() {
        return Optional.ofNullable(this.endTime);
    }

    public Optional<Instant> getPauseTime() {
        return Optional.ofNullable(this.pauseTime);
    }

    public Optional<Instant> getResumeTime() {
        return Optional.ofNullable(this.resumeTime);
    }

    @JsonIgnore
    public List<String> getUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        Set urlMap = this.jobConfig.urls.entrySet();
        urlMap.forEach(urlMapEntry -> (((UrlConfig)urlMapEntry.getValue()).paths != null ? ((UrlConfig)urlMapEntry.getValue()).paths : JobConfig.DEFAULT_PATHS).forEach(path -> urls.add(BrowserUtils.buildUrl((String)((String)urlMapEntry.getKey()), (String)path, (Map)((UrlConfig)urlMapEntry.getValue()).envMapping))));
        return urls;
    }

    public Optional<CompletableFuture<State>> getCurrentJobStepFuture() {
        return Optional.ofNullable(this.currentJobStepFuture);
    }

    public Reports getReports() {
        return this.reports;
    }

    public static Builder runStatusBuilder() {
        return new Builder();
    }

    public static Builder copyOfRunStatusBuilder(JLineupRunStatus jLineupRunStatus) {
        Builder builder = JLineupRunStatus.runStatusBuilder().withId(jLineupRunStatus.getId()).withJobConfig(jLineupRunStatus.getJobConfig()).withState(jLineupRunStatus.getState()).withStartTime(jLineupRunStatus.getStartTime()).withPauseTime(jLineupRunStatus.pauseTime).withResumeTime(jLineupRunStatus.resumeTime).withReports(jLineupRunStatus.getReports());
        jLineupRunStatus.getEndTime().ifPresent(builder::withEndTime);
        jLineupRunStatus.getCurrentJobStepFuture().ifPresent(builder::withCurrentJobStepFuture);
        return builder;
    }

    public String toString() {
        return "JLineupRunStatus{id='" + this.id + "', state=" + String.valueOf((Object)this.state) + ", startTime=" + String.valueOf(this.startTime) + ", pauseTime=" + String.valueOf(this.pauseTime) + ", resumeTime=" + String.valueOf(this.resumeTime) + ", endTime=" + String.valueOf(this.endTime) + ", reports=" + String.valueOf(this.reports) + ", currentJobStepFuture=" + String.valueOf(this.currentJobStepFuture) + ", jobConfig=" + String.valueOf(this.jobConfig) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JLineupRunStatus that = (JLineupRunStatus)o;
        return Objects.equals(this.id, that.id) && this.state == that.state && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.pauseTime, that.pauseTime) && Objects.equals(this.resumeTime, that.resumeTime) && Objects.equals(this.endTime, that.endTime) && Objects.equals(this.reports, that.reports) && Objects.equals(this.currentJobStepFuture, that.currentJobStepFuture) && Objects.equals(this.jobConfig, that.jobConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.startTime, this.pauseTime, this.resumeTime, this.endTime, this.reports, this.currentJobStepFuture, this.jobConfig});
    }

    @JsonNaming(value=PropertyNamingStrategy.class)
    public static final class Builder {
        private String id;
        private JobConfig jobConfig;
        private State state;
        private Instant startTime = Instant.now();
        private Instant pauseTime;
        private Instant resumeTime;
        private Instant endTime;
        private CompletableFuture<State> currentJobStepFuture;
        private Reports reports;

        public Builder withId(String val) {
            this.id = val;
            return this;
        }

        public Builder withJobConfig(JobConfig val) {
            this.jobConfig = val;
            return this;
        }

        public Builder withState(State val) {
            this.state = val;
            return this;
        }

        public Builder withStartTime(Instant val) {
            this.startTime = val;
            return this;
        }

        public Builder withEndTime(Instant val) {
            this.endTime = val;
            return this;
        }

        public Builder withPauseTime(Instant val) {
            this.pauseTime = val;
            return this;
        }

        public Builder withResumeTime(Instant val) {
            this.resumeTime = val;
            return this;
        }

        public Builder withCurrentJobStepFuture(CompletableFuture<State> val) {
            this.currentJobStepFuture = val;
            return this;
        }

        public Builder withReports(Reports val) {
            this.reports = val;
            return this;
        }

        public JLineupRunStatus build() {
            return new JLineupRunStatus(this);
        }
    }

    @JsonDeserialize(builder=Builder.class)
    @JsonNaming(value=PropertyNamingStrategy.class)
    public static class Reports {
        private final String htmlUrl;
        private final String jsonUrl;
        private final String logUrl;

        public Reports(Builder builder) {
            this.htmlUrl = builder.htmlUrl;
            this.jsonUrl = builder.jsonUrl;
            this.logUrl = builder.logUrl;
        }

        @JsonProperty(value="htmlUrl")
        public String getHtmlUrlFromCurrentContext() {
            if (this.htmlUrl == null) {
                return null;
            }
            try {
                return ServletUriComponentsBuilder.fromCurrentContextPath().path(this.htmlUrl).build().toString();
            }
            catch (IllegalStateException e) {
                return this.htmlUrl;
            }
        }

        @JsonProperty(value="jsonUrl")
        public String getJsonUrlFromCurrentContext() {
            if (this.jsonUrl == null) {
                return null;
            }
            try {
                return ServletUriComponentsBuilder.fromCurrentContextPath().path(this.jsonUrl).build().toString();
            }
            catch (IllegalStateException e) {
                return this.jsonUrl;
            }
        }

        @JsonProperty(value="logUrl")
        public String getLogUrlFromCurrentContext() {
            if (this.logUrl == null) {
                return null;
            }
            try {
                return ServletUriComponentsBuilder.fromCurrentContextPath().path(this.logUrl).build().toString();
            }
            catch (IllegalStateException e) {
                return this.logUrl;
            }
        }

        @JsonIgnore
        public String getHtmlUrl() {
            return this.htmlUrl;
        }

        @JsonIgnore
        public String getJsonUrl() {
            return this.jsonUrl;
        }

        @JsonIgnore
        public String getLogUrl() {
            return this.logUrl;
        }

        public static Builder reportsBuilder() {
            return new Builder();
        }

        public String toString() {
            return "Reports{htmlUrl='" + this.htmlUrl + "', jsonUrl='" + this.jsonUrl + "', logUrl='" + this.logUrl + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Reports reports = (Reports)o;
            return Objects.equals(this.htmlUrl, reports.htmlUrl) && Objects.equals(this.jsonUrl, reports.jsonUrl) && Objects.equals(this.logUrl, reports.logUrl);
        }

        public int hashCode() {
            return Objects.hash(this.htmlUrl, this.jsonUrl, this.logUrl);
        }

        @JsonNaming(value=PropertyNamingStrategy.class)
        public static final class Builder {
            private String htmlUrl;
            private String jsonUrl;
            private String logUrl;

            public Builder withHtmlUrl(String htmlUrl) {
                this.htmlUrl = htmlUrl;
                return this;
            }

            public Builder withJsonUrl(String jsonUrl) {
                this.jsonUrl = jsonUrl;
                return this;
            }

            public Builder withLogUrl(String logUrl) {
                this.logUrl = logUrl;
                return this;
            }

            public Reports build() {
                return new Reports(this);
            }
        }
    }
}

