/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.web;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.UrlConfig;
import de.otto.jlineup.web.JLineupRunStatus;
import de.otto.jlineup.web.State;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonNaming(value=PropertyNamingStrategy.class)
@JsonDeserialize(builder=Builder.class)
public class JLineupRunStatus {
    private final String id;
    private final State state;
    private final Instant startTime;
    private final Instant pauseTime;
    private final Instant resumeTime;
    private final Instant endTime;
    private final Reports reports;
    @JsonIgnore
    private final CompletableFuture<State> currentJobStepFuture;
    private final JobConfig jobConfig;

    private JLineupRunStatus(Builder builder) {
        this.id = builder.id;
        this.jobConfig = builder.jobConfig;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.pauseTime = builder.pauseTime;
        this.resumeTime = builder.resumeTime;
        this.endTime = builder.endTime;
        this.currentJobStepFuture = builder.currentJobStepFuture;
        this.reports = builder.reports;
    }

    public String getId() {
        return this.id;
    }

    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    public State getState() {
        return this.state;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Optional<Instant> getEndTime() {
        return Optional.ofNullable(this.endTime);
    }

    public Optional<Instant> getPauseTime() {
        return Optional.ofNullable(this.pauseTime);
    }

    public Optional<Instant> getResumeTime() {
        return Optional.ofNullable(this.resumeTime);
    }

    @JsonIgnore
    public List<String> getUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        Set urlMap = this.jobConfig.urls.entrySet();
        urlMap.forEach(urlMapEntry -> ((UrlConfig)urlMapEntry.getValue()).paths.forEach(path -> urls.add(BrowserUtils.buildUrl((String)((String)urlMapEntry.getKey()), (String)path, (Map)((UrlConfig)urlMapEntry.getValue()).envMapping))));
        return urls;
    }

    public Optional<CompletableFuture<State>> getCurrentJobStepFuture() {
        return Optional.ofNullable(this.currentJobStepFuture);
    }

    public Reports getReports() {
        return this.reports;
    }

    public static Builder runStatusBuilder() {
        return new Builder();
    }

    public static Builder copyOfRunStatusBuilder(JLineupRunStatus jLineupRunStatus) {
        Builder builder = JLineupRunStatus.runStatusBuilder().withId(jLineupRunStatus.getId()).withJobConfig(jLineupRunStatus.getJobConfig()).withState(jLineupRunStatus.getState()).withStartTime(jLineupRunStatus.getStartTime()).withPauseTime(jLineupRunStatus.pauseTime).withResumeTime(jLineupRunStatus.resumeTime).withReports(jLineupRunStatus.getReports());
        jLineupRunStatus.getEndTime().ifPresent(arg_0 -> ((Builder)builder).withEndTime(arg_0));
        jLineupRunStatus.getCurrentJobStepFuture().ifPresent(arg_0 -> ((Builder)builder).withCurrentJobStepFuture(arg_0));
        return builder;
    }

    public String toString() {
        return "JLineupRunStatus{id='" + this.id + "', state=" + this.state + ", startTime=" + this.startTime + ", pauseTime=" + this.pauseTime + ", resumeTime=" + this.resumeTime + ", endTime=" + this.endTime + ", reports=" + this.reports + ", currentJobStepFuture=" + this.currentJobStepFuture + ", jobConfig=" + this.jobConfig + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JLineupRunStatus that = (JLineupRunStatus)o;
        return Objects.equals(this.id, that.id) && this.state == that.state && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.pauseTime, that.pauseTime) && Objects.equals(this.resumeTime, that.resumeTime) && Objects.equals(this.endTime, that.endTime) && Objects.equals(this.reports, that.reports) && Objects.equals(this.currentJobStepFuture, that.currentJobStepFuture) && Objects.equals(this.jobConfig, that.jobConfig);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.state, this.startTime, this.pauseTime, this.resumeTime, this.endTime, this.reports, this.currentJobStepFuture, this.jobConfig);
    }
}

