/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.web;

import de.otto.jlineup.JLineupRunner;
import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.Step;
import de.otto.jlineup.service.BrowserNotInstalledException;
import de.otto.jlineup.web.configuration.JLineupWebProperties;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JLineupRunnerFactory {
    private final JLineupWebProperties properties;

    @Autowired
    public JLineupRunnerFactory(JLineupWebProperties properties) {
        this.properties = properties;
    }

    public JLineupRunner createBeforeRun(String id, JobConfig jobConfig) throws Exception {
        return this.createRun(id, jobConfig, Step.before);
    }

    public JLineupRunner createAfterRun(String id, JobConfig jobConfig) throws Exception {
        return this.createRun(id, jobConfig, Step.after);
    }

    private JLineupRunner createRun(String id, JobConfig jobConfig, Step step) throws Exception {
        JobConfig webJobConfig = this.sanitizeJobConfig(jobConfig);
        return new JLineupRunner(webJobConfig, RunStepConfig.runStepConfigBuilder().withWorkingDirectory(this.properties.getWorkingDirectory()).withScreenshotsDirectory(this.properties.getScreenshotsDirectory().replace("{id}", id)).withReportDirectory(this.properties.getReportDirectory().replace("{id}", id)).withChromeParameters(this.properties.getChromeLaunchParameters().stream().map(param -> param.replace("{id}", id)).collect(Collectors.toList())).withFirefoxParameters(this.properties.getFirefoxLaunchParameters().stream().map(param -> param.replace("{id}", id)).collect(Collectors.toList())).withStep(step).build());
    }

    JobConfig sanitizeJobConfig(JobConfig jobConfig) throws BrowserNotInstalledException {
        if (!this.properties.getInstalledBrowsers().contains(jobConfig.browser)) {
            throw new BrowserNotInstalledException(jobConfig.browser);
        }
        return JobConfig.copyOfBuilder((JobConfig)jobConfig).withThreads(this.calculateNumberOfThreads(jobConfig)).withDebug(false).withLogToFile(false).withReportFormat(2).build();
    }

    private int calculateNumberOfThreads(JobConfig jobConfig) {
        return jobConfig.threads == 0 ? this.properties.getMaxThreadsPerJob() : Math.min(jobConfig.threads, this.properties.getMaxThreadsPerJob());
    }
}

