/*
 * Decompiled with CFR 0.152.
 */
package de.otto.\u00b5service.health.configuration;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"metrics.graphite.host", "metrics.graphite.port", "metrics.graphite.prefix"})
public class GraphiteConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(GraphiteConfiguration.class);
    @Value(value="${metrics.graphite.host}")
    private String graphiteHost;
    @Value(value="${metrics.graphite.port}")
    private String graphitePort;
    @Value(value="${metrics.graphite.prefix}")
    private String graphitePrefix;
    @Autowired
    private MetricRegistry metricRegistry;

    @Bean
    public GraphiteReporter graphiteReporter() {
        InetSocketAddress address = new InetSocketAddress(this.graphiteHost, (int)Integer.valueOf(this.graphitePort));
        GraphiteReporter graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry).prefixedWith(this.graphitePrefix + "." + GraphiteConfiguration.reverse(GraphiteConfiguration.hostName()) + ".metrics").build((GraphiteSender)new Graphite(address));
        graphiteReporter.start(1L, TimeUnit.MINUTES);
        return graphiteReporter;
    }

    private static String reverse(String host) {
        List<String> parts = Arrays.asList(host.split("\\."));
        Collections.reverse(parts);
        return String.join((CharSequence)".", parts);
    }

    private static String hostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            String msg = "Error resolving canonical name of localhost";
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }
}

