/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration.sqs;

import de.otto.synapse.configuration.SynapseAutoConfiguration;
import de.otto.synapse.configuration.aws.AwsProperties;
import de.otto.synapse.configuration.aws.SynapseAwsAuthConfiguration;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.MessageQueueReceiverEndpointFactory;
import de.otto.synapse.endpoint.receiver.sqs.SqsMessageQueueReceiverEndpointFactory;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import de.otto.synapse.endpoint.sender.sqs.SqsMessageSenderEndpointFactory;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FullJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;

@Configuration
@Import(value={SynapseAwsAuthConfiguration.class, SynapseAutoConfiguration.class})
@EnableConfigurationProperties(value={AwsProperties.class})
public class SqsAutoConfiguration {
    private final AwsProperties awsProperties;

    @Autowired
    public SqsAutoConfiguration(AwsProperties awsProperties) {
        this.awsProperties = awsProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={SqsAsyncClient.class})
    public SqsAsyncClient sqsAsyncClient(AwsCredentialsProvider credentialsProvider, RetryPolicy sqsRetryPolicy) {
        return (SqsAsyncClient)((SqsAsyncClientBuilder)((SqsAsyncClientBuilder)((SqsAsyncClientBuilder)SqsAsyncClient.builder().credentialsProvider(credentialsProvider)).region(Region.of((String)this.awsProperties.getRegion()))).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().apiCallAttemptTimeout(Duration.ofSeconds(5L)).retryPolicy(sqsRetryPolicy).build())).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"sqsRetryPolicy"}, value={RetryPolicy.class})
    public RetryPolicy sqsRetryPolicy() {
        return RetryPolicy.defaultRetryPolicy().toBuilder().retryCondition(RetryCondition.defaultRetryCondition()).numRetries(Integer.valueOf(Integer.MAX_VALUE)).backoffStrategy((BackoffStrategy)FullJitterBackoffStrategy.builder().baseDelay(Duration.ofSeconds(1L)).maxBackoffTime(SdkDefaultRetrySetting.MAX_BACKOFF).build()).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"messageQueueSenderEndpointFactory"})
    public MessageSenderEndpointFactory messageQueueSenderEndpointFactory(MessageInterceptorRegistry registry, SqsAsyncClient sqsAsyncClient, @Value(value="${spring.application.name:Synapse Service}") String messageSenderName) {
        return new SqsMessageSenderEndpointFactory(registry, sqsAsyncClient);
    }

    @Bean
    @ConditionalOnMissingBean(name={"messageQueueReceiverEndpointFactory"})
    public MessageQueueReceiverEndpointFactory messageQueueReceiverEndpointFactory(MessageInterceptorRegistry registry, SqsAsyncClient sqsAsyncClient, ApplicationEventPublisher eventPublisher) {
        return new SqsMessageQueueReceiverEndpointFactory(registry, sqsAsyncClient, eventPublisher);
    }
}

