/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver.sqs;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.MessageQueueReceiverEndpoint;
import de.otto.synapse.endpoint.receiver.MessageQueueReceiverEndpointFactory;
import de.otto.synapse.endpoint.receiver.sqs.SqsMessageQueueReceiverEndpoint;
import jakarta.annotation.Nonnull;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;

public class SqsMessageQueueReceiverEndpointFactory
implements MessageQueueReceiverEndpointFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SqsMessageQueueReceiverEndpointFactory.class);
    private final MessageInterceptorRegistry registry;
    private final SqsAsyncClient sqsAsyncClient;
    private final ApplicationEventPublisher eventPublisher;

    public SqsMessageQueueReceiverEndpointFactory(MessageInterceptorRegistry registry, SqsAsyncClient sqsAsyncClient, ApplicationEventPublisher eventPublisher) {
        this.registry = registry;
        this.sqsAsyncClient = sqsAsyncClient;
        this.eventPublisher = eventPublisher;
    }

    public MessageQueueReceiverEndpoint create(@Nonnull String channelName) {
        LOG.info("Auto-configuring SQS MessageQueueReceiverEndpointFactory");
        ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("sqs-message-queue-%d").build());
        return new SqsMessageQueueReceiverEndpoint(channelName, this.registry, this.sqsAsyncClient, executorService, this.eventPublisher);
    }
}

