/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver.aws;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.otto.synapse.endpoint.receiver.aws.KinesisShardIterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class KinesisMessageLogIterator {
    private final ImmutableMap<String, KinesisShardIterator> shardIterators;

    public KinesisMessageLogIterator(@Nonnull List<KinesisShardIterator> shardIterators) {
        this.shardIterators = Maps.uniqueIndex(shardIterators, iter -> iter.getShardPosition().shardName());
    }

    @Nonnull
    public KinesisShardIterator getShardIterator(String shardName) {
        return (KinesisShardIterator)Objects.requireNonNull(this.shardIterators.get((Object)shardName), "Unknown shard " + shardName);
    }
}

