/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.message.aws;

import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.message.Header;
import de.otto.synapse.message.Message;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.model.Record;

public class KinesisMessage {
    private static final SdkBytes EMPTY_SDK_BYTES_BUFFER = SdkBytes.fromByteArray((byte[])new byte[0]);
    private static final Function<SdkBytes, String> SDK_BYTES_STRING = sdkBytes -> {
        if (sdkBytes == null || sdkBytes.equals((Object)EMPTY_SDK_BYTES_BUFFER)) {
            return null;
        }
        return sdkBytes.asString(StandardCharsets.UTF_8);
    };

    public static Message<String> kinesisMessage(@Nonnull String shard, @Nonnull Record record) {
        return Message.message((String)record.partitionKey(), (Header)Header.responseHeader((ShardPosition)ShardPosition.fromPosition((String)shard, (String)record.sequenceNumber()), (Instant)record.approximateArrivalTimestamp()), (Object)SDK_BYTES_STRING.apply(record.data()));
    }
}

