/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration.aws;

import de.otto.synapse.configuration.aws.AwsProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;

@Configuration
@EnableConfigurationProperties(value={AwsProperties.class})
public class SynapseAwsConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AwsCredentialsProvider.class})
    public AwsCredentialsProvider awsCredentialsProvider(AwsProperties awsProperties) {
        return AwsCredentialsProviderChain.builder().credentialsProviders(new AwsCredentialsProvider[]{ContainerCredentialsProvider.builder().build(), InstanceProfileCredentialsProvider.builder().build(), EnvironmentVariableCredentialsProvider.create(), ProfileCredentialsProvider.builder().profileName(awsProperties.getProfile()).build()}).build();
    }
}

