/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import de.otto.synapse.endpoint.sender.aws.KinesisMessageSender;
import de.otto.synapse.translator.JsonStringMessageTranslator;
import de.otto.synapse.translator.MessageTranslator;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.KinesisClient;

public class KinesisMessageSenderEndpointFactory
implements MessageSenderEndpointFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisMessageSenderEndpointFactory.class);
    private final MessageInterceptorRegistry registry;
    private final MessageTranslator<String> messageTranslator;
    private final KinesisClient kinesisClient;
    private final ImmutableSet<String> kinesisChannels;

    public KinesisMessageSenderEndpointFactory(MessageInterceptorRegistry registry, ObjectMapper objectMapper, KinesisClient kinesisClient) {
        this.registry = registry;
        this.messageTranslator = new JsonStringMessageTranslator(objectMapper);
        this.kinesisClient = kinesisClient;
        ImmutableSet.Builder streamNames = ImmutableSet.builder();
        try {
            streamNames.addAll((Iterable)kinesisClient.listStreams().streamNames());
        }
        catch (RuntimeException e) {
            LOG.warn("Unable to access Kinesis: {}", (Object)e.getMessage());
        }
        this.kinesisChannels = streamNames.build();
    }

    public MessageSenderEndpoint create(@Nonnull String channelName) {
        KinesisMessageSender messageSender = new KinesisMessageSender(channelName, this.messageTranslator, this.kinesisClient);
        messageSender.registerInterceptorsFrom(this.registry);
        return messageSender;
    }

    public boolean supportsChannel(String channelName) {
        return this.kinesisChannels.contains((Object)channelName);
    }
}

