/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.client.aws;

import com.google.common.io.ByteStreams;
import de.otto.synapse.client.aws.BucketItem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseInputStream;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;

public class LocalS3Client
implements S3Client {
    private static final Instant BUCKET_DEFAULT_CREATION_DATE = Instant.parse("2017-01-01T10:00:00.00Z");
    private Map<String, Map<String, BucketItem>> bucketsWithContents = new HashMap<String, Map<String, BucketItem>>();

    public ListObjectsV2Response listObjectsV2(ListObjectsV2Request listObjectsV2Request) throws S3Exception {
        Collection s3Objects = this.bucketsWithContents.get(listObjectsV2Request.bucket()).values().stream().map(bucketItem -> (S3Object)S3Object.builder().key(bucketItem.getName()).size(Long.valueOf(bucketItem.getData().length)).lastModified(bucketItem.getLastModified()).build()).collect(Collectors.toList());
        return (ListObjectsV2Response)ListObjectsV2Response.builder().contents(s3Objects).keyCount(Integer.valueOf(s3Objects.size())).build();
    }

    public CreateBucketResponse createBucket(CreateBucketRequest createBucketRequest) throws S3Exception {
        this.bucketsWithContents.put(createBucketRequest.bucket(), new HashMap());
        return (CreateBucketResponse)CreateBucketResponse.builder().build();
    }

    public PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody) throws S3Exception {
        try {
            this.bucketsWithContents.get(putObjectRequest.bucket()).put(putObjectRequest.key(), BucketItem.bucketItemBuilder().withName(putObjectRequest.key()).withData(ByteStreams.toByteArray((InputStream)requestBody.asStream())).withLastModifiedNow().build());
            return (PutObjectResponse)PutObjectResponse.builder().build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DeleteObjectsResponse deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws S3Exception {
        Map<String, BucketItem> bucketItemMap = this.bucketsWithContents.get(deleteObjectsRequest.bucket());
        deleteObjectsRequest.delete().objects().stream().map(ObjectIdentifier::key).forEach(bucketItemMap::remove);
        return (DeleteObjectsResponse)DeleteObjectsResponse.builder().build();
    }

    public ListBucketsResponse listBuckets(ListBucketsRequest listBucketsRequest) throws S3Exception {
        return (ListBucketsResponse)ListBucketsResponse.builder().buckets((Collection)this.bucketsWithContents.keySet().stream().map(name -> (Bucket)Bucket.builder().creationDate(BUCKET_DEFAULT_CREATION_DATE).name(name).build()).collect(Collectors.toList())).build();
    }

    public GetObjectResponse getObject(GetObjectRequest getObjectRequest, Path filePath) throws S3Exception {
        Map<String, BucketItem> bucketItemMap = this.bucketsWithContents.get(getObjectRequest.bucket());
        BucketItem bucketItem = bucketItemMap.get(getObjectRequest.key());
        try {
            Files.write(filePath, bucketItem.getData(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new SdkClientException((Throwable)e);
        }
        return (GetObjectResponse)GetObjectResponse.builder().build();
    }

    public ResponseInputStream<GetObjectResponse> getObject(GetObjectRequest getObjectRequest) throws S3Exception {
        Map<String, BucketItem> bucketItemMap = this.bucketsWithContents.get(getObjectRequest.bucket());
        BucketItem bucketItem = bucketItemMap.get(getObjectRequest.key());
        AbortableInputStream in = new AbortableInputStream((InputStream)new ByteArrayInputStream(bucketItem.getData()), () -> {});
        try {
            Constructor responseInputStreamConstructor = ResponseInputStream.class.getDeclaredConstructor(Object.class, AbortableInputStream.class);
            responseInputStreamConstructor.setAccessible(true);
            return (ResponseInputStream)responseInputStreamConstructor.newInstance(GetObjectResponse.builder().build(), in);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SdkClientException((Throwable)e);
        }
    }

    public void close() {
        System.out.println("s3 closing...");
    }

    public String serviceName() {
        return "s3";
    }
}

