/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.edison.aws.configuration.AwsConfiguration;
import de.otto.edison.aws.s3.configuration.S3Configuration;
import de.otto.synapse.aws.s3.SnapshotConsumerService;
import de.otto.synapse.aws.s3.SnapshotReadService;
import de.otto.synapse.configuration.aws.KinesisConfiguration;
import de.otto.synapse.configuration.aws.SnapshotAutoConfiguration;
import de.otto.synapse.configuration.aws.SnapshotProperties;
import de.otto.synapse.eventsource.aws.CompactedKinesisEventSourceBuilder;
import de.otto.synapse.eventsource.aws.KinesisEventSourceBuilder;
import de.otto.synapse.eventsource.aws.SnapshotEventSourceBuilder;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.services.kinesis.KinesisClient;

@Configuration
@ImportAutoConfiguration(value={AwsConfiguration.class, S3Configuration.class, KinesisConfiguration.class, SnapshotAutoConfiguration.class})
@EnableConfigurationProperties(value={SnapshotProperties.class})
public class AwsEventSourcingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"streamingEventSourceBuilder"})
    public KinesisEventSourceBuilder streamingEventSourceBuilder(KinesisClient kinesisClient, ApplicationEventPublisher eventPublisher, ObjectMapper objectMapper) {
        return new KinesisEventSourceBuilder(objectMapper, eventPublisher, kinesisClient);
    }

    @Bean
    @ConditionalOnMissingBean(name={"snapshotEventSourceBuilder"})
    public SnapshotEventSourceBuilder snapshotEventSourceBuilder(SnapshotReadService snapshotReadService, SnapshotConsumerService snapshotConsumerService, ObjectMapper objectMapper, ApplicationEventPublisher applicationEventPublisher) {
        return new SnapshotEventSourceBuilder(snapshotReadService, snapshotConsumerService, objectMapper, applicationEventPublisher);
    }

    @Bean
    @ConditionalOnMissingBean(name={"defaultEventSourceBuilder"})
    public CompactedKinesisEventSourceBuilder defaultEventSourceBuilder(KinesisEventSourceBuilder kinesisEventSourceBuilder, SnapshotEventSourceBuilder snapshotEventSourceBuilder) {
        return new CompactedKinesisEventSourceBuilder(kinesisEventSourceBuilder, snapshotEventSourceBuilder);
    }
}

