/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.sender.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.sender.MessageSender;
import de.otto.synapse.sender.MessageSenderFactory;
import de.otto.synapse.sender.aws.KinesisMessageSender;
import de.otto.synapse.translator.JsonByteBufferMessageTranslator;
import de.otto.synapse.translator.MessageTranslator;
import java.nio.ByteBuffer;
import software.amazon.awssdk.services.kinesis.KinesisClient;

public class KinesisMessageSenderFactory
implements MessageSenderFactory {
    private final MessageTranslator<ByteBuffer> messageTranslator;
    private final KinesisClient kinesisClient;

    public KinesisMessageSenderFactory(ObjectMapper objectMapper, KinesisClient kinesisClient) {
        this.messageTranslator = new JsonByteBufferMessageTranslator(objectMapper);
        this.kinesisClient = kinesisClient;
    }

    public MessageSender createSenderForStream(String streamName) {
        return new KinesisMessageSender(streamName, this.messageTranslator, this.kinesisClient);
    }
}

