/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.client.aws;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry;

public class RetryPutRecordsKinesisClient {
    private static final Logger LOG = LoggerFactory.getLogger(RetryPutRecordsKinesisClient.class);
    private static final int MAX_RETRY_COUNT = 3;
    private final KinesisClient kinesisClient;
    private final boolean waitBeforeRetry;

    public RetryPutRecordsKinesisClient(KinesisClient kinesisClient) {
        this(kinesisClient, true);
    }

    public RetryPutRecordsKinesisClient(KinesisClient kinesisClient, boolean waitBeforeRetry) {
        this.kinesisClient = kinesisClient;
        this.waitBeforeRetry = waitBeforeRetry;
    }

    public void putRecords(PutRecordsRequest putRecordsRequest) {
        int retryStep = 0;
        while (retryStep++ < 3) {
            PutRecordsResponse response = this.kinesisClient.putRecords(putRecordsRequest);
            if (response.failedRecordCount() == 0) {
                return;
            }
            LOG.info("Failed to write events to Kinesis: {}", (Object)response.toString());
            List<PutRecordsRequestEntry> retryRecords = this.findFailedRecords(putRecordsRequest, response);
            putRecordsRequest = (PutRecordsRequest)PutRecordsRequest.builder().records(retryRecords).streamName(putRecordsRequest.streamName()).build();
            if (this.waitBeforeRetry) {
                this.waitDependingOnRetryStep(retryStep);
            }
            if (retryStep != 3) continue;
            LOG.error("Failed to write events to Kinesis: {}", (Object)response.toString());
            throw new IllegalStateException(String.format("failed to send records after %s retries", 3));
        }
    }

    private List<PutRecordsRequestEntry> findFailedRecords(PutRecordsRequest putRecordsRequest, PutRecordsResponse response) {
        ArrayList<PutRecordsRequestEntry> retryRecords = new ArrayList<PutRecordsRequestEntry>();
        for (int i = 0; i < response.records().size(); ++i) {
            PutRecordsResultEntry record = (PutRecordsResultEntry)response.records().get(i);
            if (!"ProvisionedThroughputExceededException".equals(record.errorCode())) continue;
            retryRecords.add((PutRecordsRequestEntry)putRecordsRequest.records().get(i));
        }
        return retryRecords;
    }

    private void waitDependingOnRetryStep(int retryStep) {
        try {
            Thread.sleep((long)Math.pow(2.0, retryStep) * 1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

