/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration.aws;

import de.otto.edison.aws.s3.S3Service;
import de.otto.synapse.aws.s3.SnapshotConsumerService;
import de.otto.synapse.aws.s3.SnapshotReadService;
import de.otto.synapse.aws.s3.SnapshotWriteService;
import de.otto.synapse.configuration.aws.SnapshotProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SnapshotProperties.class})
public class SnapshotAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SnapshotReadService snapshotReadService(S3Service s3Service, SnapshotProperties snapshotProperties) {
        return new SnapshotReadService(snapshotProperties, s3Service);
    }

    @Bean
    @ConditionalOnMissingBean
    public SnapshotWriteService snapshotWriteService(S3Service s3Service, SnapshotProperties snapshotProperties) {
        return new SnapshotWriteService(s3Service, snapshotProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public SnapshotConsumerService snapshotConsumerService() {
        return new SnapshotConsumerService();
    }
}

