/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.channel.aws.KinesisMessageLog;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.eventsource.aws.KinesisEventSource;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import software.amazon.awssdk.services.kinesis.KinesisClient;

public class KinesisEventSourceBuilder
implements EventSourceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisEventSourceBuilder.class);
    private final ObjectMapper objectMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final KinesisClient kinesisClient;

    public KinesisEventSourceBuilder(ObjectMapper objectMapper, ApplicationEventPublisher eventPublisher, KinesisClient kinesisClient) {
        this.objectMapper = objectMapper;
        this.eventPublisher = eventPublisher;
        this.kinesisClient = kinesisClient;
    }

    public EventSource buildEventSource(String name, String streamName) {
        Objects.requireNonNull(streamName, "stream name must not be null");
        LOG.info("Building '{}' as KinesisEventSource", (Object)streamName);
        KinesisMessageLog messageLog = new KinesisMessageLog(this.kinesisClient, streamName);
        return new KinesisEventSource(name, messageLog, this.eventPublisher, this.objectMapper);
    }
}

