/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.aws.s3.SnapshotConsumerService;
import de.otto.synapse.aws.s3.SnapshotEventSource;
import de.otto.synapse.aws.s3.SnapshotReadService;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class SnapshotEventSourceBuilder
implements EventSourceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotEventSourceBuilder.class);
    private final SnapshotReadService snapshotReadService;
    private final SnapshotConsumerService snapshotConsumerService;
    private final ObjectMapper objectMapper;
    private final ApplicationEventPublisher applicationEventPublisher;

    public SnapshotEventSourceBuilder(SnapshotReadService snapshotReadService, SnapshotConsumerService snapshotConsumerService, ObjectMapper objectMapper, ApplicationEventPublisher applicationEventPublisher) {
        this.snapshotReadService = snapshotReadService;
        this.snapshotConsumerService = snapshotConsumerService;
        this.objectMapper = objectMapper;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public EventSource buildEventSource(String name, String streamName) {
        Objects.requireNonNull(streamName, "stream name must not be null");
        LOG.info("Building '{}' as SnapshotEventSource", (Object)streamName);
        return new SnapshotEventSource(name, streamName, this.snapshotReadService, this.snapshotConsumerService, this.applicationEventPublisher, this.objectMapper);
    }
}

